/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.client.model.ModelEnergyCube;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.client.render.tileentity.RenderEnergyCube;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.vector.Vector3f;

@ParametersAreNonnullByDefault
public class RenderFusionReactor
extends MekanismTileEntityRenderer<TileEntityFusionReactorController> {
    private static final double SCALE = 1.0E8;
    private final ModelEnergyCube.ModelEnergyCore core = new ModelEnergyCube.ModelEnergyCore();

    public RenderFusionReactor(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    protected void render(TileEntityFusionReactorController tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)tile.getMultiblock();
        if (multiblock.isFormed() && multiblock.isBurning()) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.5, -1.5, 0.5);
            long scaledTemp = Math.round(multiblock.getLastPlasmaTemp() / 1.0E8);
            float ticks = (float)MekanismClient.ticksPassed + partialTick;
            double scale = 1.0 + 0.7 * Math.sin(Math.toRadians((double)ticks * 3.14 * (double)scaledTemp + 135.0));
            IVertexBuilder buffer = this.core.getBuffer(renderer);
            this.renderPart(matrix, buffer, overlayLight, EnumColor.AQUA, scale, ticks, scaledTemp, -6, -7, 0, 36);
            scale = 1.0 + 0.8 * Math.sin(Math.toRadians(ticks * 3.0f * (float)scaledTemp));
            this.renderPart(matrix, buffer, overlayLight, EnumColor.RED, scale, ticks, scaledTemp, 4, 4, 0, 36);
            scale = 1.0 - 0.9 * Math.sin(Math.toRadians(ticks * 4.0f * (float)scaledTemp + 90.0f));
            this.renderPart(matrix, buffer, overlayLight, EnumColor.ORANGE, scale, ticks, scaledTemp, 5, -3, -35, 106);
            matrix.func_227865_b_();
        }
    }

    protected String getProfilerSection() {
        return "fusionReactor";
    }

    private void renderPart(MatrixStack matrix, IVertexBuilder buffer, int overlayLight, EnumColor color, double scale, float ticks, long scaledTemp, int mult1, int mult2, int shift1, int shift2) {
        float ticksScaledTemp = ticks * (float)scaledTemp;
        matrix.func_227860_a_();
        matrix.func_227862_a_((float)scale, (float)scale, (float)scale);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(ticksScaledTemp * (float)mult1 + (float)shift1));
        matrix.func_227863_a_(RenderEnergyCube.coreVec.func_229187_a_(ticksScaledTemp * (float)mult2 + (float)shift2));
        this.core.render(matrix, buffer, 0xF000F0, overlayLight, color, 1.0f);
        matrix.func_227865_b_();
    }

    public boolean isGlobalRenderer(TileEntityFusionReactorController tile) {
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)tile.getMultiblock();
        return multiblock.isFormed() && multiblock.isBurning();
    }
}

