/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyTile;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.transmitters.ITransmitterTile;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.util.CableUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2"), @Optional.Interface(iface="ic2.api.tile.IEnergyStorage", modid="IC2")})
public class TileEntityInductionPort
extends TileEntityInductionCasing
implements IEnergyWrapper,
IConfigurable,
IActiveState {
    public boolean ic2Registered = false;
    public boolean mode;

    public TileEntityInductionPort() {
        super("InductionPort");
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.ic2Registered && MekanismUtils.useIC2()) {
            this.register();
        }
        if (!this.field_145850_b.field_72995_K && this.structure != null && this.mode) {
            double prev = this.getEnergy();
            CableUtils.emit(this);
            ((SynchronizedMatrixData)this.structure).remainingOutput -= prev - this.getEnergy();
        }
    }

    @Override
    public EnumSet<ForgeDirection> getOutputtingSides() {
        if (this.structure != null && this.mode) {
            EnumSet<ForgeDirection> set = EnumSet.allOf(ForgeDirection.class);
            set.remove(ForgeDirection.UNKNOWN);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (!((SynchronizedMatrixData)this.structure).locations.contains(Coord4D.get(this).getFromSide(side))) continue;
                set.remove(side);
            }
            return set;
        }
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        if (this.structure != null && !this.mode) {
            EnumSet<ForgeDirection> set = EnumSet.allOf(ForgeDirection.class);
            set.remove(ForgeDirection.UNKNOWN);
            return set;
        }
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Optional.Method(modid="IC2")
    public void register() {
        TileEntity registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTileEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) != this) {
            if (registered instanceof IEnergyTile) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)registered));
            } else if (registered == null) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
                this.ic2Registered = true;
            }
        }
    }

    @Optional.Method(modid="IC2")
    public void deregister() {
        TileEntity registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTileEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) instanceof IEnergyTile) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)registered));
        }
    }

    @Override
    public double getMaxOutput() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).remainingOutput : 0.0;
    }

    private double getMaxInput() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).remainingInput : 0.0;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.mode = dataStream.readBoolean();
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.mode);
        return data;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (MekanismUtils.useIC2()) {
            this.register();
        }
    }

    public void onChunkUnload() {
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.mode = nbtTags.func_74767_n("mode");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("mode", this.mode);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.getConsumingSides().contains(from)) {
            double toAdd = (int)Math.min(Math.min(this.getMaxInput(), this.getMaxEnergy() - this.getEnergy()), (double)maxReceive * MekanismConfig.general.FROM_TE);
            if (!simulate) {
                this.setEnergy(this.getEnergy() + toAdd);
                ((SynchronizedMatrixData)this.structure).remainingInput -= toAdd;
            }
            return (int)Math.round(toAdd * MekanismConfig.general.TO_TE);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.getOutputtingSides().contains(from)) {
            double toSend = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), (double)maxExtract * MekanismConfig.general.FROM_TE));
            if (!simulate) {
                this.setEnergy(this.getEnergy() - toSend);
                ((SynchronizedMatrixData)this.structure).remainingOutput -= toSend;
            }
            return (int)Math.round(toSend * MekanismConfig.general.TO_TE);
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.structure != null;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_TE);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)Math.round(this.getMaxEnergy() * MekanismConfig.general.TO_TE);
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public void setStored(int energy) {
        this.setEnergy((double)energy * MekanismConfig.general.FROM_IC2);
    }

    @Optional.Method(modid="IC2")
    public int addEnergy(int amount) {
        double toUse = Math.min(Math.min(this.getMaxInput(), this.getMaxEnergy() - this.getEnergy()), (double)amount * MekanismConfig.general.FROM_IC2);
        this.setEnergy(this.getEnergy() + toUse);
        ((SynchronizedMatrixData)this.structure).remainingInput -= toUse;
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public boolean isTeleporterCompatible(ForgeDirection side) {
        return this.canOutputTo(side);
    }

    @Override
    public boolean canOutputTo(ForgeDirection side) {
        return this.getOutputtingSides().contains(side);
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.getConsumingSides().contains(direction);
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.getOutputtingSides().contains(direction) && receiver instanceof IEnergyConductor;
    }

    @Optional.Method(modid="IC2")
    public int getStored() {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public int getCapacity() {
        return (int)Math.round(this.getMaxEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public int getOutput() {
        return (int)Math.round(this.getMaxOutput() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return (this.getMaxEnergy() - this.getEnergy()) * MekanismConfig.general.TO_IC2;
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        return Math.min(this.getEnergy(), this.getMaxOutput()) * MekanismConfig.general.TO_IC2;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return this.getConsumingSides().contains(side);
    }

    @Optional.Method(modid="IC2")
    public double getOutputEnergyUnitsPerTick() {
        return this.getMaxOutput() * MekanismConfig.general.TO_IC2;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection direction, double amount, double voltage) {
        if (Coord4D.get(this).getFromSide(direction).getTileEntity((IBlockAccess)this.field_145850_b) instanceof ITransmitterTile) {
            return amount;
        }
        return amount - this.transferEnergyToAcceptor(direction, amount * MekanismConfig.general.FROM_IC2) * MekanismConfig.general.TO_IC2;
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount) {
        if (this.structure != null) {
            double toDraw = Math.min(amount * MekanismConfig.general.FROM_IC2, this.getMaxOutput());
            this.setEnergy(Math.max(this.getEnergy() - toDraw, 0.0));
            ((SynchronizedMatrixData)this.structure).remainingOutput -= toDraw;
        }
    }

    @Override
    public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
        if (!this.getConsumingSides().contains(side)) {
            return 0.0;
        }
        double toUse = Math.min(Math.min(this.getMaxInput(), this.getMaxEnergy() - this.getEnergy()), amount);
        this.setEnergy(this.getEnergy() + toUse);
        ((SynchronizedMatrixData)this.structure).remainingInput -= toUse;
        return toUse;
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        if (!this.field_145850_b.field_72995_K) {
            this.mode = !this.mode;
            String modeText = " " + (Object)((Object)(this.mode ? EnumColor.DARK_RED : EnumColor.DARK_GREEN)) + LangUtils.transOutputInput(this.mode) + ".";
            player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configurator.inductionPortMode") + modeText));
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.func_70296_d();
        }
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        return false;
    }

    @Override
    public boolean getActive() {
        return this.mode;
    }

    @Override
    public void setActive(boolean active) {
        this.mode = active;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }
}

