/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.outputs;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.outputs.MachineOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PressurizedOutput
extends MachineOutput<PressurizedOutput> {
    private ItemStack itemOutput;
    private GasStack gasOutput;

    public PressurizedOutput(ItemStack item, GasStack gas) {
        this.itemOutput = item;
        this.gasOutput = gas;
    }

    public PressurizedOutput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.itemOutput = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("itemOutput"));
        this.gasOutput = GasStack.readFromNBT(nbtTags.func_74775_l("gasOutput"));
    }

    public boolean canFillTank(GasTank tank) {
        return tank.canReceive(this.gasOutput.getGas()) && tank.getNeeded() >= this.gasOutput.amount;
    }

    public boolean canAddProducts(ItemStack[] inventory, int index) {
        return inventory[index] == null || inventory[index].func_77969_a(this.itemOutput) && inventory[index].field_77994_a + this.itemOutput.field_77994_a <= inventory[index].func_77976_d();
    }

    public void fillTank(GasTank tank) {
        tank.receive(this.gasOutput, true);
    }

    public void addProducts(ItemStack[] inventory, int index) {
        if (inventory[index] == null) {
            inventory[index] = this.itemOutput.func_77946_l();
        } else if (inventory[index].func_77969_a(this.itemOutput)) {
            inventory[index].field_77994_a += this.itemOutput.field_77994_a;
        }
    }

    public boolean applyOutputs(ItemStack[] inventory, int index, GasTank tank, boolean doEmit) {
        if (this.canFillTank(tank) && this.canAddProducts(inventory, index)) {
            if (doEmit) {
                this.fillTank(tank);
                this.addProducts(inventory, index);
            }
            return true;
        }
        return false;
    }

    public ItemStack getItemOutput() {
        return this.itemOutput;
    }

    public GasStack getGasOutput() {
        return this.gasOutput;
    }

    @Override
    public PressurizedOutput copy() {
        return new PressurizedOutput(this.itemOutput.func_77946_l(), this.gasOutput.copy());
    }
}

