/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.common.PacketHandler;
import mekanism.common.base.ITileNetwork;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;

public class PacketTileEntity
implements IMessageHandler<TileEntityMessage, IMessage> {
    public IMessage onMessage(TileEntityMessage message, MessageContext context) {
        TileEntity tileEntity = message.coord4D.getTileEntity((IBlockAccess)PacketHandler.getPlayer((MessageContext)context).field_70170_p);
        if (tileEntity instanceof ITileNetwork) {
            try {
                ((ITileNetwork)tileEntity).handlePacketData(message.storedBuffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            message.storedBuffer.release();
        }
        return null;
    }

    public static class TileEntityMessage
    implements IMessage {
        public Coord4D coord4D;
        public ArrayList parameters;
        public ByteBuf storedBuffer = null;

        public TileEntityMessage() {
        }

        public TileEntityMessage(Coord4D coord, ArrayList params) {
            this.coord4D = coord;
            this.parameters = params;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.coord4D.xCoord);
            dataStream.writeInt(this.coord4D.yCoord);
            dataStream.writeInt(this.coord4D.zCoord);
            dataStream.writeInt(this.coord4D.dimensionId);
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                WorldServer world = server.func_71218_a(this.coord4D.dimensionId);
                PacketHandler.log("Sending TileEntity packet from coordinate " + this.coord4D + " (" + this.coord4D.getTileEntity((IBlockAccess)world) + ")");
            }
            PacketHandler.encode(new Object[]{this.parameters}, dataStream);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            this.storedBuffer = dataStream.copy();
        }
    }
}

