/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.multipart.TMultiPart;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.multipart.PartLogisticalTransporter;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.LangUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class PartDiversionTransporter
extends PartLogisticalTransporter {
    public int[] modes = new int[]{0, 0, 0, 0, 0, 0};

    @Override
    public String getType() {
        return "mekanism:diversion_transporter";
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.DIVERSION_TRANSPORTER;
    }

    @Override
    public IIcon getCenterIcon(boolean opaque) {
        return transporterIcons.getCenterIcon(5);
    }

    @Override
    public IIcon getSideIcon(boolean opaque) {
        return transporterIcons.getSideIcon(opaque ? 14 : (this.getTransmitter().color != null ? 11 : 10));
    }

    @Override
    public IIcon getSideIconRotated(boolean opaque) {
        return transporterIcons.getSideIcon(opaque ? 15 : (this.getTransmitter().color != null ? 13 : 12));
    }

    @Override
    public boolean renderCenter() {
        return true;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        this.modes = nbtTags.func_74759_k("modes");
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74783_a("modes", this.modes);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        super.handlePacketData(dataStream);
        if (this.world().field_72995_K) {
            this.modes[0] = dataStream.readInt();
            this.modes[1] = dataStream.readInt();
            this.modes[2] = dataStream.readInt();
            this.modes[3] = dataStream.readInt();
            this.modes[4] = dataStream.readInt();
            this.modes[5] = dataStream.readInt();
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data = super.getNetworkedData(data);
        data.add(this.modes[0]);
        data.add(this.modes[1]);
        data.add(this.modes[2]);
        data.add(this.modes[3]);
        data.add(this.modes[4]);
        data.add(this.modes[5]);
        return data;
    }

    @Override
    public ArrayList getSyncPacket(TransporterStack stack, boolean kill) {
        ArrayList data = super.getSyncPacket(stack, kill);
        data.add(this.modes[0]);
        data.add(this.modes[1]);
        data.add(this.modes[2]);
        data.add(this.modes[3]);
        data.add(this.modes[4]);
        data.add(this.modes[5]);
        return data;
    }

    @Override
    protected boolean onConfigure(EntityPlayer player, int part, int side) {
        int newMode = (this.modes[side] + 1) % 3;
        String description = "ERROR";
        this.modes[side] = newMode;
        switch (newMode) {
            case 0: {
                description = LangUtils.localize("control.disabled.desc");
                break;
            }
            case 1: {
                description = LangUtils.localize("control.high.desc");
                break;
            }
            case 2: {
                description = LangUtils.localize("control.low.desc");
            }
        }
        this.refreshConnections();
        this.tile().notifyPartChange((TMultiPart)this);
        this.notifyTileChange();
        player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.configurator.toggleDiverter") + ": " + (Object)((Object)EnumColor.RED) + description));
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this.tile()), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get((TileEntity)this.tile())));
        return true;
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        if (!super.canConnect(side)) {
            return false;
        }
        int mode = this.modes[side.ordinal()];
        boolean redstone = this.world().func_72864_z(this.x(), this.y(), this.z());
        return (mode != 2 || !redstone) && (mode != 1 || redstone);
    }
}

