/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.common.item.ItemMekanism;
import mekanism.common.util.LangUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemFlamethrower
extends ItemMekanism
implements IGasItem {
    public int TRANSFER_RATE = 16;

    public ItemFlamethrower() {
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        GasStack gasStack = this.getGas(itemstack);
        if (gasStack == null) {
            list.add(LangUtils.localize("tooltip.noGas") + ".");
        } else {
            list.add(LangUtils.localize("tooltip.stored") + " " + gasStack.getGas().getLocalizedName() + ": " + gasStack.amount);
        }
        list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.mode") + ": " + (Object)((Object)EnumColor.GREY) + this.getMode(itemstack).getName());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
    }

    public void useGas(ItemStack stack) {
        this.setGas(stack, new GasStack(this.getGas(stack).getGas(), this.getGas((ItemStack)stack).amount - 1));
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return MekanismConfig.general.maxFlamethrowerGas;
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return this.TRANSFER_RATE;
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        if (stack.getGas() != GasRegistry.getGas("hydrogen")) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        return null;
    }

    public int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return type == GasRegistry.getGas("hydrogen");
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return false;
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return null;
        }
        return GasStack.readFromNBT(itemstack.field_77990_d.func_74775_l("stored"));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (this.getGas(stack) != null ? (double)this.getGas((ItemStack)stack).amount : 0.0) / (double)this.getMaxGas(stack);
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        if (stack == null || stack.amount == 0) {
            itemstack.field_77990_d.func_82580_o("stored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            itemstack.field_77990_d.func_74782_a("stored", (NBTBase)gasStack.write(new NBTTagCompound()));
        }
    }

    public ItemStack getEmptyItem() {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        return empty;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        list.add(empty);
        ItemStack filled = new ItemStack((Item)this);
        this.setGas(filled, new GasStack(GasRegistry.getGas("hydrogen"), ((IGasItem)filled.func_77973_b()).getMaxGas(filled)));
        list.add(filled);
    }

    public void incrementMode(ItemStack stack) {
        this.setMode(stack, this.getMode(stack).increment());
    }

    public FlamethrowerMode getMode(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return FlamethrowerMode.COMBAT;
        }
        return FlamethrowerMode.values()[stack.field_77990_d.func_74762_e("mode")];
    }

    public void setMode(ItemStack stack, FlamethrowerMode mode) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74768_a("mode", mode.ordinal());
    }

    public static enum FlamethrowerMode {
        COMBAT("tooltip.flamethrower.combat", EnumColor.YELLOW),
        HEAT("tooltip.flamethrower.heat", EnumColor.ORANGE),
        INFERNO("tooltip.flamethrower.inferno", EnumColor.DARK_RED);

        private String unlocalized;
        private EnumColor color;

        private FlamethrowerMode(String s, EnumColor c) {
            this.unlocalized = s;
            this.color = c;
        }

        public FlamethrowerMode increment() {
            return this.ordinal() < FlamethrowerMode.values().length - 1 ? FlamethrowerMode.values()[this.ordinal() + 1] : FlamethrowerMode.values()[0];
        }

        public String getName() {
            return (Object)((Object)this.color) + LangUtils.localize(this.unlocalized);
        }
    }
}

