/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import buildcraft.api.tools.IToolWrench;
import cofh.api.item.IToolHammer;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.IMekWrench;
import mekanism.api.Range4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.item.ItemEnergized;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraft")})
public class ItemConfigurator
extends ItemEnergized
implements IMekWrench,
IToolWrench,
IToolHammer {
    public final int ENERGY_PER_CONFIGURE = 400;
    public final int ENERGY_PER_ITEM_DUMP = 8;
    private Random random = new Random();

    public ItemConfigurator() {
        super(60000.0);
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        super.func_77624_a(itemstack, entityplayer, list, flag);
        list.add((Object)((Object)EnumColor.PINK) + LangUtils.localize("gui.state") + ": " + (Object)((Object)this.getColor(this.getState(itemstack))) + this.getStateDisplay(this.getState(itemstack)));
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            Block block = world.func_147439_a(x, y, z);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (this.getState(stack).isConfigurating()) {
                if (tile instanceof ISideConfiguration && ((ISideConfiguration)tile).getConfig().supports(this.getState(stack).getTransmission())) {
                    ISideConfiguration config = (ISideConfiguration)tile;
                    SideData initial = config.getConfig().getOutput(this.getState(stack).getTransmission(), side, config.getOrientation());
                    if (initial != TileComponentConfig.EMPTY) {
                        if (!player.func_70093_af()) {
                            player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + this.getViewModeText(this.getState(stack).getTransmission()) + ": " + (Object)((Object)initial.color) + initial.localize() + " (" + initial.color.getName() + ")"));
                        } else if (this.getEnergy(stack) >= 400.0) {
                            if (SecurityUtils.canAccess(player, tile)) {
                                this.setEnergy(stack, this.getEnergy(stack) - 400.0);
                                MekanismUtils.incrementOutput(config, this.getState(stack).getTransmission(), MekanismUtils.getBaseOrientation(side, config.getOrientation()));
                                SideData data = config.getConfig().getOutput(this.getState(stack).getTransmission(), side, config.getOrientation());
                                player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + this.getToggleModeText(this.getState(stack).getTransmission()) + ": " + (Object)((Object)data.color) + data.localize() + " (" + data.color.getName() + ")"));
                                if (config instanceof TileEntityBasicBlock) {
                                    TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)((Object)config);
                                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
                                }
                            } else {
                                SecurityUtils.displayNoAccess(player);
                            }
                        }
                    }
                    return true;
                }
                if (tile instanceof IConfigurable) {
                    IConfigurable config = (IConfigurable)tile;
                    if (SecurityUtils.canAccess(player, tile)) {
                        if (player.func_70093_af()) {
                            return config.onSneakRightClick(player, side);
                        }
                        return config.onRightClick(player, side);
                    }
                    SecurityUtils.displayNoAccess(player);
                    return true;
                }
            } else if (this.getState(stack) == ConfiguratorMode.EMPTY) {
                if (tile instanceof TileEntityContainerBlock) {
                    IInventory inv = (IInventory)tile;
                    if (SecurityUtils.canAccess(player, tile)) {
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            ItemStack slotStack = inv.func_70301_a(i);
                            if (slotStack == null) continue;
                            if (this.getEnergy(stack) < 8.0) break;
                            float xRandom = this.random.nextFloat() * 0.8f + 0.1f;
                            float yRandom = this.random.nextFloat() * 0.8f + 0.1f;
                            float zRandom = this.random.nextFloat() * 0.8f + 0.1f;
                            while (slotStack.field_77994_a > 0) {
                                int j = this.random.nextInt(21) + 10;
                                if (j > slotStack.field_77994_a) {
                                    j = slotStack.field_77994_a;
                                }
                                slotStack.field_77994_a -= j;
                                EntityItem item = new EntityItem(world, (double)((float)x + xRandom), (double)((float)y + yRandom), (double)((float)z + zRandom), new ItemStack(slotStack.func_77973_b(), j, slotStack.func_77960_j()));
                                if (slotStack.func_77942_o()) {
                                    item.func_92059_d().func_77982_d((NBTTagCompound)slotStack.func_77978_p().func_74737_b());
                                }
                                float k = 0.05f;
                                item.field_70159_w = this.random.nextGaussian() * (double)k;
                                item.field_70181_x = this.random.nextGaussian() * (double)k + (double)0.2f;
                                item.field_70179_y = this.random.nextGaussian() * (double)k;
                                world.func_72838_d((Entity)item);
                                inv.func_70299_a(i, null);
                                this.setEnergy(stack, this.getEnergy(stack) - 8.0);
                            }
                        }
                        return true;
                    }
                    SecurityUtils.displayNoAccess(player);
                    return true;
                }
            } else {
                if (this.getState(stack) == ConfiguratorMode.ROTATE) {
                    ForgeDirection axis = ForgeDirection.getOrientation((int)side);
                    List<ForgeDirection> l = Arrays.asList(block.getValidRotations(world, x, y, z));
                    if (!player.func_70093_af() && l.contains(axis)) {
                        block.rotateBlock(world, x, y, z, axis);
                    } else if (player.func_70093_af() && l.contains(axis.getOpposite())) {
                        block.rotateBlock(world, x, y, z, axis.getOpposite());
                    }
                    return true;
                }
                if (this.getState(stack) == ConfiguratorMode.WRENCH) {
                    return false;
                }
            }
        }
        return false;
    }

    public String getViewModeText(TransmissionType type) {
        String base = LangUtils.localize("tooltip.configurator.viewMode");
        return String.format(base, type.localize().toLowerCase());
    }

    public String getToggleModeText(TransmissionType type) {
        String base = LangUtils.localize("tooltip.configurator.toggleMode");
        return String.format(base, type.localize());
    }

    public String getStateDisplay(ConfiguratorMode mode) {
        return mode.getName();
    }

    public EnumColor getColor(ConfiguratorMode mode) {
        return mode.getColor();
    }

    public void setState(ItemStack itemstack, ConfiguratorMode state) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.field_77990_d.func_74768_a("state", state.ordinal());
    }

    public ConfiguratorMode getState(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return ConfiguratorMode.CONFIGURATE_ITEMS;
        }
        if (itemstack.field_77990_d.func_74781_a("state") != null) {
            return ConfiguratorMode.values()[itemstack.field_77990_d.func_74762_e("state")];
        }
        return ConfiguratorMode.CONFIGURATE_ITEMS;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Optional.Method(modid="BuildCraft")
    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        return this.canUseWrench(player, x, y, z);
    }

    @Optional.Method(modid="BuildCraft")
    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
    }

    @Override
    public boolean canUseWrench(EntityPlayer player, int x, int y, int z) {
        return this.getState(player.func_71045_bC()) == ConfiguratorMode.WRENCH;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return this.getState(player.func_71045_bC()) == ConfiguratorMode.WRENCH;
    }

    @Override
    public boolean isUsable(ItemStack item, EntityLivingBase user, int x, int y, int z) {
        return user instanceof EntityPlayer && this.canUseWrench((EntityPlayer)user, x, y, z);
    }

    @Override
    public void toolUsed(ItemStack item, EntityLivingBase user, int x, int y, int z) {
    }

    public static enum ConfiguratorMode {
        CONFIGURATE_ITEMS("configurate", "(" + TransmissionType.ITEM.localize() + ")", EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_FLUIDS("configurate", "(" + TransmissionType.FLUID.localize() + ")", EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_GASES("configurate", "(" + TransmissionType.GAS.localize() + ")", EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_ENERGY("configurate", "(" + TransmissionType.ENERGY.localize() + ")", EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_HEAT("configurate", "(" + TransmissionType.HEAT.localize() + ")", EnumColor.BRIGHT_GREEN, true),
        EMPTY("empty", "", EnumColor.DARK_RED, false),
        ROTATE("rotate", "", EnumColor.YELLOW, false),
        WRENCH("wrench", "", EnumColor.PINK, false);

        private String name;
        private String info;
        private EnumColor color;
        private boolean configurating;

        private ConfiguratorMode(String s, String s1, EnumColor c, boolean b) {
            this.name = s;
            this.info = s1;
            this.color = c;
            this.configurating = b;
        }

        public String getName() {
            return LangUtils.localize("tooltip.configurator." + this.name) + " " + this.info;
        }

        public EnumColor getColor() {
            return this.color;
        }

        public boolean isConfigurating() {
            return this.configurating;
        }

        public TransmissionType getTransmission() {
            switch (this) {
                case CONFIGURATE_ITEMS: {
                    return TransmissionType.ITEM;
                }
                case CONFIGURATE_FLUIDS: {
                    return TransmissionType.FLUID;
                }
                case CONFIGURATE_GASES: {
                    return TransmissionType.GAS;
                }
                case CONFIGURATE_ENERGY: {
                    return TransmissionType.ENERGY;
                }
                case CONFIGURATE_HEAT: {
                    return TransmissionType.HEAT;
                }
            }
            return null;
        }
    }
}

