/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiSolarNeutronActivator;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.opengl.GL11;

public class SolarNeutronRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;
    public static int xOffset = 5;
    public static int yOffset = 12;

    public String getRecipeName() {
        return LangUtils.localize("tile.MachineBlock3.SolarNeutronActivator.name");
    }

    public String getOverlayIdentifier() {
        return "solarneutron";
    }

    public String getGuiTexture() {
        return "mekanism:gui/nei/GuiSolarNeutronActivator.png";
    }

    public Class getGuiClass() {
        return GuiSolarNeutronActivator.class;
    }

    public String getRecipeId() {
        return "mekanism.solarneutron";
    }

    public Collection<SolarNeutronRecipe> getRecipes() {
        return RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.get().values();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)yOffset, (int)170, (int)70);
    }

    public void drawExtras(int i) {
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        GuiDraw.drawTexturedModalRect((int)(64 - xOffset), (int)(39 - yOffset), (int)176, (int)58, (int)55, (int)8);
        if (recipe.inputStack != null) {
            this.displayGauge(58, 26 - xOffset, 14 - yOffset, 176, 0, 58, null, recipe.inputStack);
        }
        if (recipe.inputStack != null) {
            this.displayGauge(58, 134 - xOffset, 14 - yOffset, 176, 0, 58, null, recipe.outputStack);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(64 - xOffset, 39 - yOffset, 48, 8), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (SolarNeutronRecipe irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else if (outputId.equals("gas") && results.length == 1 && results[0] instanceof GasStack) {
            for (SolarNeutronRecipe irecipe : this.getRecipes()) {
                if (!((GasStack)results[0]).isGasEqual(((GasOutput)irecipe.getOutput()).output)) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("gas") && ingredients.length == 1 && ingredients[0] instanceof GasStack) {
            for (SolarNeutronRecipe irecipe : this.getRecipes()) {
                if (!((GasInput)irecipe.getInput()).ingredient.isGasEqual((GasStack)ingredients[0])) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        if (xAxis >= 26 && xAxis <= 42 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(LangUtils.localizeGasStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).inputStack));
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(LangUtils.localizeGasStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack));
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack gas = null;
        if (xAxis >= 26 && xAxis <= 42 && yAxis >= 18 && yAxis <= 76) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).inputStack;
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 18 && yAxis <= 76) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack;
        }
        if (gas != null && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doGasLookup(gas, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doGasLookup(gas, true))) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack gas = null;
        if (xAxis >= 26 && xAxis <= 42 && yAxis >= 32 && yAxis <= 90) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).inputStack;
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 32 && yAxis <= 90) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack;
        }
        if (gas != null && (button == 0 ? this.doGasLookup(gas, false) : button == 1 && this.doGasLookup(gas, true))) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    @Override
    public void addGuiElements() {
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public GasStack inputStack;
        public GasStack outputStack;

        public PositionedStack getResult() {
            return null;
        }

        public CachedIORecipe(GasStack input, GasStack output) {
            super((TemplateRecipeHandler)SolarNeutronRecipeHandler.this);
            this.inputStack = input;
            this.outputStack = output;
        }

        public CachedIORecipe(SolarNeutronRecipe recipe) {
            this(((GasInput)recipe.getInput()).ingredient, ((GasOutput)recipe.getOutput()).output);
        }
    }
}

