/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util.text;

import java.util.UUID;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.client.MekanismClient;
import mekanism.common.MekanismLang;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;

public class OwnerDisplay
implements IHasTextComponent {
    private final PlayerEntity player;
    private final UUID ownerUUID;
    private final String ownerName;

    private OwnerDisplay(PlayerEntity player, UUID ownerUUID, String ownerName) {
        this.player = player;
        this.ownerUUID = ownerUUID;
        this.ownerName = ownerName;
    }

    public static OwnerDisplay of(UUID ownerUUID) {
        return OwnerDisplay.of(null, ownerUUID);
    }

    public static OwnerDisplay of(PlayerEntity player, UUID ownerUUID) {
        return OwnerDisplay.of(player, ownerUUID, null);
    }

    public static OwnerDisplay of(UUID ownerUUID, String ownerName) {
        return OwnerDisplay.of(null, ownerUUID, ownerName);
    }

    public static OwnerDisplay of(PlayerEntity player, UUID ownerUUID, String ownerName) {
        return new OwnerDisplay(player, ownerUUID, ownerName);
    }

    @Override
    public ITextComponent getTextComponent() {
        String name;
        if (this.ownerUUID == null) {
            return MekanismLang.NO_OWNER.translateColored(EnumColor.RED, new Object[0]);
        }
        String string = name = this.ownerName == null ? MekanismClient.clientUUIDMap.get(this.ownerUUID) : this.ownerName;
        if (this.player == null) {
            return MekanismLang.OWNER.translateColored(EnumColor.DARK_GRAY, name);
        }
        return MekanismLang.OWNER.translateColored(EnumColor.DARK_GRAY, this.player.func_110124_au().equals(this.ownerUUID) ? EnumColor.BRIGHT_GREEN : EnumColor.RED, name);
    }
}

