/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util.text;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.text.ITextComponent;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EnergyDisplay
implements IHasTextComponent {
    public static final EnergyDisplay ZERO = EnergyDisplay.of(FloatingLong.ZERO);
    private final FloatingLong energy;
    private final FloatingLong max;

    private EnergyDisplay(FloatingLong energy, FloatingLong max) {
        this.energy = energy;
        this.max = max;
    }

    public static EnergyDisplay of(FloatingLong energy, FloatingLong max) {
        return new EnergyDisplay(energy, max);
    }

    public static EnergyDisplay of(FloatingLong energy) {
        return EnergyDisplay.of(energy, FloatingLong.ZERO);
    }

    @Override
    public ITextComponent getTextComponent() {
        if (this.energy.equals(FloatingLong.MAX_VALUE)) {
            return MekanismLang.INFINITE.translate(new Object[0]);
        }
        if (this.max.isZero()) {
            return MekanismUtils.getEnergyDisplayShort(this.energy);
        }
        return MekanismLang.GENERIC_FRACTION.translate(MekanismUtils.getEnergyDisplayShort(this.energy), EnergyDisplay.of(this.max));
    }
}

