/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import javax.annotation.Nonnull;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.util.EnumUtils;
import net.minecraft.util.text.ITextComponent;

public class UnitDisplayUtils {
    public static ITextComponent getDisplay(FloatingLong value, ElectricUnit unit, int decimalPlaces, boolean isShort) {
        ILangEntry label = unit.pluralLangEntry;
        if (isShort) {
            label = unit.shortLangEntry;
        } else if (value.equals(FloatingLong.ONE)) {
            label = unit.singularLangEntry;
        }
        if (value.isZero()) {
            return TextComponentUtil.build(value + " ", label);
        }
        for (int i = 0; i < EnumUtils.FLOATING_LONG_MEASUREMENT_UNITS.length; ++i) {
            FloatingLongMeasurementUnit lowerMeasure = EnumUtils.FLOATING_LONG_MEASUREMENT_UNITS[i];
            if (i == 0 && lowerMeasure.below(value)) {
                return TextComponentUtil.build(lowerMeasure.process(value).toString(decimalPlaces) + " " + lowerMeasure.getName(isShort), label);
            }
            if (i + 1 >= EnumUtils.FLOATING_LONG_MEASUREMENT_UNITS.length) {
                return TextComponentUtil.build(lowerMeasure.process(value).toString(decimalPlaces) + " " + lowerMeasure.getName(isShort), label);
            }
            FloatingLongMeasurementUnit upperMeasure = EnumUtils.FLOATING_LONG_MEASUREMENT_UNITS[i + 1];
            if ((!lowerMeasure.above(value) || !upperMeasure.below(value)) && !lowerMeasure.value.equals(value)) continue;
            return TextComponentUtil.build(lowerMeasure.process(value).toString(decimalPlaces) + " " + lowerMeasure.getName(isShort), label);
        }
        return TextComponentUtil.build(value.toString(decimalPlaces), label);
    }

    public static ITextComponent getDisplayShort(FloatingLong value, ElectricUnit unit) {
        return UnitDisplayUtils.getDisplay(value, unit, 2, true);
    }

    public static ITextComponent getDisplay(double temp, TemperatureUnit unit, int decimalPlaces, boolean shift, boolean isShort) {
        return UnitDisplayUtils.getDisplayBase(unit.convertFromK(temp, shift), unit, decimalPlaces, isShort, false);
    }

    public static ITextComponent getDisplayBase(double value, Unit unit, int decimalPlaces, boolean isShort, boolean spaceBetweenSymbol) {
        String spaceStr;
        ILangEntry label = unit.getLabel();
        String prefix = "";
        String string = spaceStr = spaceBetweenSymbol ? " " : "";
        if (value < 0.0) {
            value = Math.abs(value);
            prefix = "-";
        }
        if (value == 0.0) {
            return isShort ? TextComponentUtil.getString(value + spaceStr + unit.getSymbol()) : TextComponentUtil.build(value, label);
        }
        for (int i = 0; i < EnumUtils.MEASUREMENT_UNITS.length; ++i) {
            MeasurementUnit lowerMeasure = EnumUtils.MEASUREMENT_UNITS[i];
            String symbolStr = spaceStr + lowerMeasure.symbol;
            if (lowerMeasure.below(value) && lowerMeasure.ordinal() == 0) {
                if (isShort) {
                    return TextComponentUtil.getString(prefix + UnitDisplayUtils.roundDecimals(lowerMeasure.process(value), decimalPlaces) + symbolStr + unit.getSymbol());
                }
                return TextComponentUtil.build(prefix + UnitDisplayUtils.roundDecimals(lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.name, label);
            }
            if (lowerMeasure.ordinal() + 1 >= EnumUtils.MEASUREMENT_UNITS.length) {
                if (isShort) {
                    return TextComponentUtil.getString(prefix + UnitDisplayUtils.roundDecimals(lowerMeasure.process(value), decimalPlaces) + symbolStr + unit.getSymbol());
                }
                return TextComponentUtil.build(prefix + UnitDisplayUtils.roundDecimals(lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.name, label);
            }
            if (i + 1 >= EnumUtils.MEASUREMENT_UNITS.length) continue;
            MeasurementUnit upperMeasure = EnumUtils.MEASUREMENT_UNITS[i + 1];
            if ((!lowerMeasure.above(value) || !upperMeasure.below(value)) && lowerMeasure.value != value) continue;
            if (isShort) {
                return TextComponentUtil.getString(prefix + UnitDisplayUtils.roundDecimals(lowerMeasure.process(value), decimalPlaces) + symbolStr + unit.getSymbol());
            }
            return TextComponentUtil.build(prefix + UnitDisplayUtils.roundDecimals(lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.name, label);
        }
        if (isShort) {
            return TextComponentUtil.getString(prefix + UnitDisplayUtils.roundDecimals(value, decimalPlaces) + spaceStr + unit.getSymbol());
        }
        return TextComponentUtil.build(prefix + UnitDisplayUtils.roundDecimals(value, decimalPlaces) + " ", label);
    }

    public static ITextComponent getDisplayShort(double value, TemperatureUnit unit) {
        return UnitDisplayUtils.getDisplayShort(value, unit, true);
    }

    public static ITextComponent getDisplayShort(double value, TemperatureUnit unit, boolean shift) {
        return UnitDisplayUtils.getDisplayShort(value, unit, shift, 2);
    }

    public static ITextComponent getDisplayShort(double value, TemperatureUnit unit, boolean shift, int decimalPlaces) {
        return UnitDisplayUtils.getDisplay(value, unit, decimalPlaces, shift, true);
    }

    public static ITextComponent getDisplayShort(double value, RadiationUnit unit, int decimalPlaces) {
        return UnitDisplayUtils.getDisplayBase(value, unit, decimalPlaces, true, true);
    }

    public static double roundDecimals(double d, int decimalPlaces) {
        int j = (int)(d * Math.pow(10.0, decimalPlaces));
        return (double)j / Math.pow(10.0, decimalPlaces);
    }

    public static double roundDecimals(double d) {
        return UnitDisplayUtils.roundDecimals(d, 2);
    }

    public static enum TempType implements IIncrementalEnum<TempType>,
    IHasTranslationKey
    {
        K(MekanismLang.TEMPERATURE_KELVIN_SHORT),
        C(MekanismLang.TEMPERATURE_CELSIUS_SHORT),
        R(MekanismLang.TEMPERATURE_RANKINE_SHORT),
        F(MekanismLang.TEMPERATURE_FAHRENHEIT_SHORT),
        STP(MekanismLang.TEMPERATURE_AMBIENT_SHORT);

        private static final TempType[] TYPES;
        private final ILangEntry langEntry;

        private TempType(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        @Override
        @Nonnull
        public TempType byIndex(int index) {
            return MathUtils.getByIndexMod(TYPES, index);
        }

        static {
            TYPES = TempType.values();
        }
    }

    public static enum EnergyType implements IIncrementalEnum<EnergyType>,
    IHasTranslationKey
    {
        J(MekanismLang.ENERGY_JOULES_SHORT),
        FE(MekanismLang.ENERGY_FORGE_SHORT),
        EU(MekanismLang.ENERGY_EU_SHORT);

        private static final EnergyType[] TYPES;
        private final ILangEntry langEntry;

        private EnergyType(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        @Override
        @Nonnull
        public EnergyType byIndex(int index) {
            return MathUtils.getByIndexMod(TYPES, index);
        }

        static {
            TYPES = EnergyType.values();
        }
    }

    public static enum FloatingLongMeasurementUnit {
        MILLI("Milli", "m", FloatingLong.createConst(0.001)),
        BASE("", "", FloatingLong.ONE),
        KILO("Kilo", "k", FloatingLong.createConst(1000L)),
        MEGA("Mega", "M", FloatingLong.createConst(1000000L)),
        GIGA("Giga", "G", FloatingLong.createConst(1000000000L)),
        TERA("Tera", "T", FloatingLong.createConst(1000000000000L)),
        PETA("Peta", "P", FloatingLong.createConst(1000000000000000L)),
        EXA("Exa", "E", FloatingLong.createConst(1000000000000000000L));

        private final String name;
        private final String symbol;
        private final FloatingLong value;

        private FloatingLongMeasurementUnit(String name, String symbol, FloatingLong value) {
            this.name = name;
            this.symbol = symbol;
            this.value = value;
        }

        public String getName(boolean getShort) {
            if (getShort) {
                return this.symbol;
            }
            return this.name;
        }

        public FloatingLong process(FloatingLong d) {
            return d.divide(this.value);
        }

        public boolean above(FloatingLong d) {
            return d.greaterThan(this.value);
        }

        public boolean below(FloatingLong d) {
            return d.smallerThan(this.value);
        }
    }

    public static enum MeasurementUnit {
        FEMTO("Femto", "f", 1.0E-15),
        PICO("Pico", "p", 1.0E-12),
        NANO("Nano", "n", 1.0E-9),
        MICRO("Micro", "u", 1.0E-6),
        MILLI("Milli", "m", 0.001),
        BASE("", "", 1.0),
        KILO("Kilo", "k", 1000.0),
        MEGA("Mega", "M", 1000000.0),
        GIGA("Giga", "G", 1.0E9),
        TERA("Tera", "T", 1.0E12),
        PETA("Peta", "P", 1.0E15),
        EXA("Exa", "E", 1.0E18),
        ZETTA("Zetta", "Z", 1.0E21),
        YOTTA("Yotta", "Y", 1.0E24);

        private final String name;
        private final String symbol;
        private final double value;

        private MeasurementUnit(String name, String symbol, double value) {
            this.name = name;
            this.symbol = symbol;
            this.value = value;
        }

        public String getName(boolean getShort) {
            if (getShort) {
                return this.symbol;
            }
            return this.name;
        }

        public double process(double d) {
            return d / this.value;
        }

        public boolean above(double d) {
            return d > this.value;
        }

        public boolean below(double d) {
            return d < this.value;
        }
    }

    public static enum RadiationUnit implements Unit
    {
        SV("Sv"),
        SVH("Sv/h");

        private final String symbol;

        private RadiationUnit(String symbol) {
            this.symbol = symbol;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }

        @Override
        public ILangEntry getLabel() {
            return MekanismLang.ERROR;
        }
    }

    public static enum TemperatureUnit implements Unit
    {
        KELVIN(MekanismLang.TEMPERATURE_KELVIN, "K", 0.0, 1.0),
        CELSIUS(MekanismLang.TEMPERATURE_CELSIUS, "\u00b0C", 273.15, 1.0),
        RANKINE(MekanismLang.TEMPERATURE_RANKINE, "R", 0.0, 1.8),
        FAHRENHEIT(MekanismLang.TEMPERATURE_FAHRENHEIT, "\u00b0F", 459.67, 1.8),
        AMBIENT(MekanismLang.TEMPERATURE_AMBIENT, "+STP", 300.0, 1.0);

        private final ILangEntry langEntry;
        private final String symbol;
        public final double zeroOffset;
        public final double intervalSize;

        private TemperatureUnit(ILangEntry langEntry, String symbol, double offset, double size) {
            this.langEntry = langEntry;
            this.symbol = symbol;
            this.zeroOffset = offset;
            this.intervalSize = size;
        }

        public double convertFromK(double temp, boolean shift) {
            return temp * this.intervalSize - (shift ? this.zeroOffset : 0.0);
        }

        public double convertToK(double temp, boolean shift) {
            return (temp + (shift ? this.zeroOffset : 0.0)) / this.intervalSize;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }

        @Override
        public ILangEntry getLabel() {
            return this.langEntry;
        }
    }

    public static enum ElectricUnit {
        JOULES(MekanismLang.ENERGY_JOULES, MekanismLang.ENERGY_JOULES_PLURAL, MekanismLang.ENERGY_JOULES_SHORT),
        FORGE_ENERGY(MekanismLang.ENERGY_FORGE, MekanismLang.ENERGY_FORGE, MekanismLang.ENERGY_FORGE_SHORT),
        ELECTRICAL_UNITS(MekanismLang.ENERGY_EU, MekanismLang.ENERGY_EU_PLURAL, MekanismLang.ENERGY_EU_SHORT);

        private final ILangEntry singularLangEntry;
        private final ILangEntry pluralLangEntry;
        private final ILangEntry shortLangEntry;

        private ElectricUnit(ILangEntry singularLangEntry, ILangEntry pluralLangEntry, ILangEntry shortLangEntry) {
            this.singularLangEntry = singularLangEntry;
            this.pluralLangEntry = pluralLangEntry;
            this.shortLangEntry = shortLangEntry;
        }
    }

    private static interface Unit {
        public String getSymbol();

        public ILangEntry getLabel();
    }
}

