/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.bytes.ByteConsumer;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.shorts.ShortConsumer;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Coord4D;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.BoxedChemical;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class NBTUtils {
    private NBTUtils() {
    }

    public static void setByteIfPresent(CompoundNBT nbt, String key, ByteConsumer setter) {
        if (nbt.func_150297_b(key, 1)) {
            setter.accept(nbt.func_74771_c(key));
        }
    }

    public static void setBooleanIfPresent(CompoundNBT nbt, String key, BooleanConsumer setter) {
        if (nbt.func_150297_b(key, 1)) {
            setter.accept(nbt.func_74767_n(key));
        }
    }

    public static void setShortIfPresent(CompoundNBT nbt, String key, ShortConsumer setter) {
        if (nbt.func_150297_b(key, 2)) {
            setter.accept(nbt.func_74765_d(key));
        }
    }

    public static void setIntIfPresent(CompoundNBT nbt, String key, IntConsumer setter) {
        if (nbt.func_150297_b(key, 3)) {
            setter.accept(nbt.func_74762_e(key));
        }
    }

    public static void setLongIfPresent(CompoundNBT nbt, String key, LongConsumer setter) {
        if (nbt.func_150297_b(key, 4)) {
            setter.accept(nbt.func_74763_f(key));
        }
    }

    public static void setFloatIfPresent(CompoundNBT nbt, String key, FloatConsumer setter) {
        if (nbt.func_150297_b(key, 5)) {
            setter.accept(nbt.func_74760_g(key));
        }
    }

    public static void setDoubleIfPresent(CompoundNBT nbt, String key, DoubleConsumer setter) {
        if (nbt.func_150297_b(key, 6)) {
            setter.accept(nbt.func_74769_h(key));
        }
    }

    public static void setByteArrayIfPresent(CompoundNBT nbt, String key, Consumer<byte[]> setter) {
        if (nbt.func_150297_b(key, 7)) {
            setter.accept(nbt.func_74770_j(key));
        }
    }

    public static void setStringIfPresent(CompoundNBT nbt, String key, Consumer<String> setter) {
        if (nbt.func_150297_b(key, 8)) {
            setter.accept(nbt.func_74779_i(key));
        }
    }

    public static void setListIfPresent(CompoundNBT nbt, String key, int type, Consumer<ListNBT> setter) {
        if (nbt.func_150297_b(key, 9)) {
            setter.accept(nbt.func_150295_c(key, type));
        }
    }

    public static void setCompoundIfPresent(CompoundNBT nbt, String key, Consumer<CompoundNBT> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(nbt.func_74775_l(key));
        }
    }

    public static void setIntArrayIfPresent(CompoundNBT nbt, String key, Consumer<int[]> setter) {
        if (nbt.func_150297_b(key, 11)) {
            setter.accept(nbt.func_74759_k(key));
        }
    }

    public static void setLongArrayIfPresent(CompoundNBT nbt, String key, Consumer<long[]> setter) {
        if (nbt.func_150297_b(key, 12)) {
            setter.accept(nbt.func_197645_o(key));
        }
    }

    public static boolean hasOldUUID(CompoundNBT nbt, String key) {
        return nbt.func_150297_b(key + "Most", 99) && nbt.func_150297_b(key + "Least", 99);
    }

    public static UUID getOldUUID(CompoundNBT nbt, String key) {
        return new UUID(nbt.func_74763_f(key + "Most"), nbt.func_74763_f(key + "Least"));
    }

    public static void setUUIDIfPresent(CompoundNBT nbt, String key, Consumer<UUID> setter) {
        if (nbt.func_186855_b(key)) {
            setter.accept(nbt.func_186857_a(key));
        } else if (NBTUtils.hasOldUUID(nbt, key)) {
            setter.accept(NBTUtils.getOldUUID(nbt, key));
        }
    }

    public static void setUUIDIfPresentElse(CompoundNBT nbt, String key, Consumer<UUID> setter, Runnable notPresent) {
        if (nbt.func_186855_b(key)) {
            setter.accept(nbt.func_186857_a(key));
        } else if (NBTUtils.hasOldUUID(nbt, key)) {
            setter.accept(NBTUtils.getOldUUID(nbt, key));
        } else {
            notPresent.run();
        }
    }

    public static void setBlockPosIfPresent(CompoundNBT nbt, String key, Consumer<BlockPos> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l(key)));
        }
    }

    public static void setCoord4DIfPresent(CompoundNBT nbt, String key, Consumer<Coord4D> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(Coord4D.read(nbt.func_74775_l(key)));
        }
    }

    public static void setFluidStackIfPresent(CompoundNBT nbt, String key, Consumer<FluidStack> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l(key)));
        }
    }

    public static void setBoxedChemicalIfPresent(CompoundNBT nbt, String key, Consumer<BoxedChemical> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(BoxedChemical.read(nbt.func_74775_l(key)));
        }
    }

    public static void setGasIfPresent(CompoundNBT nbt, String key, Consumer<Gas> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(Gas.readFromNBT(nbt.func_74775_l(key)));
        }
    }

    public static void setGasStackIfPresent(CompoundNBT nbt, String key, Consumer<GasStack> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(GasStack.readFromNBT(nbt.func_74775_l(key)));
        }
    }

    public static void setInfuseTypeIfPresent(CompoundNBT nbt, String key, Consumer<InfuseType> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(InfuseType.readFromNBT(nbt.func_74775_l(key)));
        }
    }

    public static void setInfusionStackIfPresent(CompoundNBT nbt, String key, Consumer<InfusionStack> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(InfusionStack.readFromNBT(nbt.func_74775_l(key)));
        }
    }

    public static void setPigmentIfPresent(CompoundNBT nbt, String key, Consumer<Pigment> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(Pigment.readFromNBT(nbt.func_74775_l(key)));
        }
    }

    public static void setPigmentStackIfPresent(CompoundNBT nbt, String key, Consumer<PigmentStack> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(PigmentStack.readFromNBT(nbt.func_74775_l(key)));
        }
    }

    public static void setSlurryIfPresent(CompoundNBT nbt, String key, Consumer<Slurry> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(Slurry.readFromNBT(nbt.func_74775_l(key)));
        }
    }

    public static void setSlurryStackIfPresent(CompoundNBT nbt, String key, Consumer<SlurryStack> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(SlurryStack.readFromNBT(nbt.func_74775_l(key)));
        }
    }

    public static void setFloatingLongIfPresent(CompoundNBT nbt, String key, FloatingLongConsumer setter) {
        if (nbt.func_150297_b(key, 8)) {
            try {
                setter.accept(FloatingLong.parseFloatingLong(nbt.func_74779_i(key)));
            }
            catch (NumberFormatException e) {
                setter.accept(FloatingLong.ZERO);
            }
        }
    }

    public static void setItemStackIfPresent(CompoundNBT nbt, String key, Consumer<ItemStack> setter) {
        if (nbt.func_150297_b(key, 10)) {
            setter.accept(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l(key)));
        }
    }

    public static void setResourceLocationIfPresent(CompoundNBT nbt, String key, Consumer<ResourceLocation> setter) {
        ResourceLocation value;
        if (nbt.func_150297_b(key, 8) && (value = ResourceLocation.func_208304_a((String)nbt.func_74779_i(key))) != null) {
            setter.accept(value);
        }
    }

    public static <ENUM extends Enum<ENUM>> void setEnumIfPresent(CompoundNBT nbt, String key, Int2ObjectFunction<ENUM> indexLookup, Consumer<ENUM> setter) {
        if (nbt.func_150297_b(key, 3)) {
            setter.accept(indexLookup.apply(nbt.func_74762_e(key)));
        }
    }
}

