/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.IConfigCardAccess;
import mekanism.api.Upgrade;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.list.SyncableFilterList;
import mekanism.common.lib.HashList;
import mekanism.common.tile.interfaces.IHasSortableFilters;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.qio.TileEntityQIOComponent;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class TileEntityQIOFilterHandler
extends TileEntityQIOComponent
implements IConfigCardAccess.ISpecialConfigData,
ISustainedData,
ITileFilterHolder<QIOFilter<?>>,
IHasSortableFilters {
    private HashList<QIOFilter<?>> filters = new HashList();

    public TileEntityQIOFilterHandler(IBlockProvider blockProvider) {
        super(blockProvider);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, this));
    }

    @Override
    public HashList<QIOFilter<?>> getFilters() {
        return this.filters;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (QIOFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "filters", 9)) {
            ListNBT tagList = ItemDataUtils.getList(itemStack, "filters");
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof QIOFilter)) continue;
                this.filters.add((QIOFilter)filter);
            }
        }
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("filters", "filters");
        return remap;
    }

    @Override
    public CompoundNBT getConfigurationData(CompoundNBT nbtTags) {
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (QIOFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            nbtTags.func_218657_a("filters", (INBT)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void setConfigurationData(CompoundNBT nbtTags) {
        if (nbtTags.func_150297_b("filters", 9)) {
            ListNBT tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof QIOFilter)) continue;
                this.filters.add((QIOFilter)filter);
            }
        }
    }

    @Override
    public String getDataType() {
        return this.getBlockType().func_149739_a();
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        return this.getConfigurationData(nbtTags);
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        this.setConfigurationData(nbtTags);
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFilterList.create(this::getFilters, value -> {
            this.filters = value instanceof HashList ? (HashList)value : new HashList(value);
        }));
    }

    @Override
    public void moveUp(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex - 1);
        this.markDirty(false);
    }

    @Override
    public void moveDown(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex + 1);
        this.markDirty(false);
    }

    protected int getMaxTransitCount() {
        return 64 + 32 * this.upgradeComponent.getUpgrades(Upgrade.SPEED);
    }

    protected int getMaxTransitTypes() {
        return Math.round(1.0f + (float)this.upgradeComponent.getUpgrades(Upgrade.SPEED) / 2.0f);
    }
}

