/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import javax.annotation.Nonnull;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.content.qio.IQIOFrequencyHolder;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;

public class TileEntityQIOComponent
extends TileEntityMekanism
implements IQIOFrequencyHolder {
    private EnumColor lastColor;

    public TileEntityQIOComponent(IBlockProvider blockProvider) {
        super(blockProvider);
        this.frequencyComponent.track(FrequencyType.QIO, true, true, true);
    }

    public EnumColor getColor() {
        return this.lastColor;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        EnumColor prev = this.lastColor;
        QIOFrequency frequency = this.getQIOFrequency();
        EnumColor enumColor = this.lastColor = frequency != null ? frequency.getColor() : null;
        if (prev != this.lastColor) {
            this.sendUpdatePacket();
        }
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        if (this.lastColor != null) {
            updateTag.func_74768_a("color", this.lastColor.ordinal());
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.lastColor = tag.func_150297_b("color", 3) ? EnumColor.byIndexStatic(tag.func_74762_e("color")) : null;
        WorldUtils.updateBlock(this.func_145831_w(), this.func_174877_v(), this);
    }
}

