/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import javax.annotation.Nonnull;
import mekanism.api.IConfigurable;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.ProxiedEnergyContainerHolder;
import mekanism.common.content.matrix.MatrixMultiblockData;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.multiblock.TileEntityInductionCasing;
import mekanism.common.util.CableUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;

public class TileEntityInductionPort
extends TileEntityInductionCasing
implements IConfigurable {
    public TileEntityInductionPort() {
        super(MekanismBlocks.INDUCTION_PORT);
        this.delaySupplier = () -> 0;
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        return ProxiedEnergyContainerHolder.create(side -> !this.getActive(), side -> this.getActive(), side -> ((MatrixMultiblockData)this.getMultiblock()).getEnergyContainers((Direction)side));
    }

    @Override
    protected void onUpdateServer(MatrixMultiblockData multiblock) {
        super.onUpdateServer(multiblock);
        if (multiblock.isFormed() && this.getActive()) {
            CableUtils.emit(multiblock.getDirectionsToEmit(this.func_174877_v()), multiblock.getEnergyContainer(), (TileEntity)this);
        }
    }

    @Override
    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.ENERGY) {
            return false;
        }
        return super.persists(type);
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote()) {
            boolean oldMode = this.getActive();
            this.setActive(!oldMode);
            player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, EnumColor.GRAY, MekanismLang.INDUCTION_PORT_MODE.translate(BooleanStateDisplay.InputOutput.of(oldMode, true))), Util.field_240973_b_);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public int getRedstoneLevel() {
        return ((MatrixMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }
}

