/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackGasToItemStackCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;

public class TileEntityAntiprotonicNucleosynthesizer
extends TileEntityProgressMachine<NucleosynthesizingRecipe> {
    public static final int BASE_TICKS_REQUIRED = 400;
    public static final long MAX_GAS = 10000L;
    public IGasTank gasTank;
    protected final IOutputHandler<@NonNull ItemStack> outputHandler;
    protected final IInputHandler<@NonNull ItemStack> itemInputHandler;
    protected final ILongInputHandler<@NonNull GasStack> gasInputHandler;
    private MachineEnergyContainer<TileEntityAntiprotonicNucleosynthesizer> energyContainer;
    private GasInventorySlot gasInputSlot;
    private InputInventorySlot inputSlot;
    private OutputInventorySlot outputSlot;
    private EnergyInventorySlot energySlot;
    public FloatingLong clientEnergyUsed = FloatingLong.ZERO;

    public TileEntityAntiprotonicNucleosynthesizer() {
        super(MekanismBlocks.ANTIPROTONIC_NUCLEOSYNTHESIZER, 400);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.ENERGY);
        this.configComponent.setupItemIOExtraConfig(this.inputSlot, this.outputSlot, this.gasInputSlot, this.energySlot);
        this.configComponent.setupInputConfig(TransmissionType.GAS, this.gasTank);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM);
        this.itemInputHandler = InputHelper.getInputHandler(this.inputSlot);
        this.gasInputHandler = InputHelper.getInputHandler(this.gasTank);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputSlot);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.gasTank = ChemicalTankBuilder.GAS.input(10000L, gas -> this.containsRecipe(recipe -> ((GasStackIngredient)recipe.getChemicalInput()).testType(gas)), this);
        builder.addTank(this.gasTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.gasInputSlot = GasInventorySlot.fillOrConvert(this.gasTank, () -> ((TileEntityAntiprotonicNucleosynthesizer)this).func_145831_w(), this, 6, 69);
        builder.addSlot(this.gasInputSlot);
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipe(recipe -> recipe.getItemInput().testType(item)), this, 26, 40);
        builder.addSlot(this.inputSlot);
        this.outputSlot = OutputInventorySlot.at(this, 152, 40);
        builder.addSlot(this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityAntiprotonicNucleosynthesizer)this).func_145831_w(), this, 173, 69);
        builder.addSlot(this.energySlot);
        this.gasInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    public double getProcessRate() {
        return this.clientEnergyUsed.divide(this.energyContainer.getEnergyPerTick()).doubleValue();
    }

    @Override
    protected void onUpdateServer() {
        this.energySlot.fillContainerOrConvert();
        this.gasInputSlot.fillTankOrConvert();
        FloatingLong prev = this.energyContainer.getEnergy().copyAsConst();
        this.cachedRecipe = this.getUpdatedCache(0);
        int n = this.ticksRequired = this.cachedRecipe == null ? 400 : ((NucleosynthesizingRecipe)this.cachedRecipe.getRecipe()).getDuration();
        if (this.cachedRecipe != null) {
            int toProcess = (int)Math.sqrt(this.energyContainer.getEnergy().divide(this.energyContainer.getEnergyPerTick()).doubleValue());
            this.cachedRecipe.process();
            for (int i = 0; i < toProcess - 1; ++i) {
                this.cachedRecipe.process();
            }
        }
        this.clientEnergyUsed = prev.subtract(this.energyContainer.getEnergy());
    }

    @Override
    @Nullable
    public CachedRecipe<NucleosynthesizingRecipe> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipe;
    }

    @Override
    @Nullable
    public NucleosynthesizingRecipe getRecipe(int cacheIndex) {
        ItemStack stack = this.itemInputHandler.getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        GasStack gasStack = (GasStack)this.gasInputHandler.getInput();
        if (gasStack.isEmpty()) {
            return null;
        }
        return (NucleosynthesizingRecipe)this.findFirstRecipe(recipe -> recipe.test(stack, gasStack));
    }

    @Override
    @Nullable
    public CachedRecipe<NucleosynthesizingRecipe> createNewCachedRecipe(@Nonnull NucleosynthesizingRecipe recipe, int cacheIndex) {
        return new ItemStackGasToItemStackCachedRecipe<NucleosynthesizingRecipe>(recipe, this.itemInputHandler, this.gasInputHandler, () -> 0L, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(this::setOperatingTicks);
    }

    public MachineEnergyContainer<TileEntityAntiprotonicNucleosynthesizer> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    @Nonnull
    public MekanismRecipeType<NucleosynthesizingRecipe> getRecipeType() {
        return MekanismRecipeType.NUCLEOSYNTHESIZING;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFloatingLong.create(() -> this.clientEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }
}

