/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.laser;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.inventory.AutomationType;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.Mekanism;
import mekanism.common.base.MekFakePlayer;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.network.PacketLaserHitBlock;
import mekanism.common.particle.LaserParticleData;
import mekanism.common.registries.MekanismDamageSource;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public abstract class TileEntityBasicLaser
extends TileEntityMekanism {
    protected LaserEnergyContainer energyContainer;
    private BlockPos digging;
    private FloatingLong diggingProgress = FloatingLong.ZERO;
    private FloatingLong lastFired = FloatingLong.ZERO;

    public TileEntityBasicLaser(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.addInitialEnergyContainers(builder);
        return builder.build();
    }

    protected abstract void addInitialEnergyContainers(EnergyContainerHelper var1);

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        FloatingLong firing = this.energyContainer.extract(this.toFire(), Action.SIMULATE, AutomationType.INTERNAL);
        if (!firing.isZero()) {
            if (!firing.equals(this.lastFired) || !this.getActive()) {
                this.setActive(true);
                this.lastFired = firing;
                this.sendUpdatePacket();
            }
            Direction direction = this.getDirection();
            Pos3D from = Pos3D.create(this).centre().translate(direction, 0.501);
            Pos3D to = from.translate(direction, (double)MekanismConfig.general.laserRange.get() - 0.002);
            BlockRayTraceResult result = this.getWorldNN().func_217299_a(new RayTraceContext((Vector3d)from, (Vector3d)to, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, null));
            if (result.func_216346_c() != RayTraceResult.Type.MISS) {
                to = new Pos3D(result.func_216347_e());
            }
            float laserEnergyScale = this.getEnergyScale(firing);
            FloatingLong remainingEnergy = firing.copy();
            List hitEntities = this.getWorldNN().func_217357_a(Entity.class, Pos3D.getAABB(from, to));
            if (hitEntities.isEmpty()) {
                this.setEmittingRedstone(false);
            } else {
                this.setEmittingRedstone(true);
                Pos3D finalFrom = from;
                hitEntities.sort(Comparator.comparing(entity -> entity.func_195048_a((Vector3d)finalFrom)));
                FloatingLong energyPerDamage = (FloatingLong)MekanismConfig.general.laserEnergyPerDamage.get();
                for (Entity entity2 : hitEntities) {
                    if (entity2.func_180431_b((DamageSource)MekanismDamageSource.LASER)) {
                        remainingEnergy = FloatingLong.ZERO;
                        to = from.adjustPosition(direction, entity2);
                        break;
                    }
                    if (entity2 instanceof ItemEntity && this.handleHitItem((ItemEntity)entity2)) continue;
                    FloatingLong value = remainingEnergy.divide(energyPerDamage);
                    float damage = value.floatValue();
                    float health = 0.0f;
                    if (entity2 instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity2;
                        if (livingEntity.func_184585_cz() && livingEntity.func_184607_cu().isShield(livingEntity)) {
                            float damageBlocked = this.damageShield(livingEntity, livingEntity.func_184607_cu(), damage, 2);
                            if ((remainingEnergy = remainingEnergy.minusEqual(energyPerDamage.multiply(damageBlocked))).isZero()) {
                                to = from.adjustPosition(direction, entity2);
                                break;
                            }
                            value = remainingEnergy.divide(energyPerDamage);
                            damage = value.floatValue();
                        }
                        health = livingEntity.func_110143_aJ();
                    }
                    if (!entity2.func_230279_az_()) {
                        entity2.func_70015_d(value.intValue());
                    }
                    int lastHurtResistTime = entity2.field_70172_ad;
                    entity2.field_70172_ad = 0;
                    boolean damaged = entity2.func_70097_a((DamageSource)MekanismDamageSource.LASER, damage);
                    entity2.field_70172_ad = lastHurtResistTime;
                    if (!damaged) continue;
                    if (entity2 instanceof LivingEntity) {
                        damage = Math.min(damage, Math.max(0.0f, health - ((LivingEntity)entity2).func_110143_aJ()));
                    }
                    if ((remainingEnergy = remainingEnergy.minusEqual(energyPerDamage.multiply(damage))).isZero()) {
                        to = from.adjustPosition(direction, entity2);
                        break;
                    }
                    float energyScale = this.getEnergyScale(remainingEnergy);
                    if (!((double)(laserEnergyScale - energyScale) > 0.01)) continue;
                    Pos3D entityPos = from.adjustPosition(direction, entity2);
                    this.sendLaserDataToPlayers(new LaserParticleData(direction, entityPos.distance(from), laserEnergyScale), from);
                    laserEnergyScale = energyScale;
                    from = entityPos;
                }
            }
            this.sendLaserDataToPlayers(new LaserParticleData(direction, to.distance(from), laserEnergyScale), from);
            if (remainingEnergy.isZero() || result.func_216346_c() == RayTraceResult.Type.MISS) {
                this.digging = null;
                this.diggingProgress = FloatingLong.ZERO;
            } else {
                Optional capability;
                BlockPos hitPos = result.func_216350_a();
                if (!hitPos.equals((Object)this.digging)) {
                    this.digging = result.func_216346_c() == RayTraceResult.Type.MISS ? null : hitPos;
                    this.diggingProgress = FloatingLong.ZERO;
                }
                if ((capability = CapabilityUtils.getCapability((ICapabilityProvider)WorldUtils.getTileEntity((IBlockReader)this.field_145850_b, hitPos), Capabilities.LASER_RECEPTOR_CAPABILITY, result.func_216354_b()).resolve()).isPresent() && !((ILaserReceptor)capability.get()).canLasersDig()) {
                    ((ILaserReceptor)capability.get()).receiveLaserEnergy(remainingEnergy, result.func_216354_b());
                } else {
                    BlockState hitState = this.field_145850_b.func_180495_p(hitPos);
                    float hardness = hitState.func_185887_b((IBlockReader)this.field_145850_b, hitPos);
                    if (hardness >= 0.0f) {
                        this.diggingProgress = this.diggingProgress.plusEqual(remainingEnergy);
                        if (this.diggingProgress.compareTo(((FloatingLong)MekanismConfig.general.laserEnergyNeededPerHardness.get()).multiply(hardness)) >= 0) {
                            if (MekanismConfig.general.aestheticWorldDamage.get()) {
                                MekFakePlayer.withFakePlayer((ServerWorld)this.field_145850_b, to.func_82615_a(), to.func_82617_b(), to.func_82616_c(), dummy -> {
                                    dummy.setEmulatingUUID(this.getOwnerUUID());
                                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.field_145850_b, hitPos, hitState, (PlayerEntity)dummy);
                                    if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                                        this.handleBreakBlock(hitState, hitPos);
                                        hitState.func_196947_b(this.field_145850_b, hitPos, Blocks.field_150350_a.func_176223_P(), false);
                                        this.field_145850_b.func_217377_a(hitPos, false);
                                        this.field_145850_b.func_217379_c(2001, hitPos, Block.func_196246_j((BlockState)hitState));
                                    }
                                    return null;
                                });
                            }
                            this.diggingProgress = FloatingLong.ZERO;
                        } else {
                            Mekanism.packetHandler.sendToAllTracking(new PacketLaserHitBlock(result), this);
                        }
                    }
                }
            }
            this.energyContainer.extract(firing, Action.EXECUTE, AutomationType.INTERNAL);
        } else if (this.getActive()) {
            this.setActive(false);
            if (!this.diggingProgress.isZero()) {
                this.diggingProgress = FloatingLong.ZERO;
            }
            if (!this.lastFired.isZero()) {
                this.lastFired = FloatingLong.ZERO;
                this.sendUpdatePacket();
            }
        }
    }

    private float damageShield(LivingEntity livingEntity, ItemStack activeStack, float damage, int absorptionRation) {
        float damageBlocked = damage;
        float effectiveDamage = damage / (float)absorptionRation;
        if (effectiveDamage >= 1.0f) {
            int durabilityNeeded = 1 + MathHelper.func_76141_d((float)effectiveDamage);
            int activeDurability = activeStack.func_77958_k() - activeStack.func_77952_i();
            Hand hand = livingEntity.func_184600_cs();
            activeStack.func_222118_a(durabilityNeeded, livingEntity, entity -> {
                entity.func_213334_d(hand);
                if (livingEntity instanceof PlayerEntity) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)((PlayerEntity)livingEntity), (ItemStack)activeStack, (Hand)hand);
                }
            });
            if (activeStack.func_190926_b()) {
                if (hand == Hand.MAIN_HAND) {
                    livingEntity.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    livingEntity.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                livingEntity.func_184602_cy();
                livingEntity.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + 0.4f * this.field_145850_b.field_73012_v.nextFloat());
                int unblockedDamage = (durabilityNeeded - activeDurability) * absorptionRation;
                damageBlocked = Math.max(0.0f, damage - (float)unblockedDamage);
            }
        }
        if (livingEntity instanceof ServerPlayerEntity && damageBlocked > 0.0f && damageBlocked < 3.4028235E37f) {
            ((ServerPlayerEntity)livingEntity).func_195067_a(Stats.field_212737_I, Math.round(damageBlocked * 10.0f));
        }
        return damageBlocked;
    }

    private float getEnergyScale(FloatingLong energy) {
        return Math.min(energy.divide((FloatingLong)MekanismConfig.usage.laser.get()).divide(10L).floatValue(), 0.6f);
    }

    private void sendLaserDataToPlayers(LaserParticleData data, Pos3D from) {
        if (!this.isRemote() && this.field_145850_b instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
            for (ServerPlayerEntity player : serverWorld.func_217369_A()) {
                serverWorld.func_195600_a(player, (IParticleData)data, true, from.field_72450_a, from.field_72448_b, from.field_72449_c, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void setEmittingRedstone(boolean foundEntity) {
    }

    protected boolean handleHitItem(ItemEntity entity) {
        return false;
    }

    protected void handleBreakBlock(BlockState state, BlockPos hitPos) {
        Block.func_220059_a((BlockState)state, (IWorld)this.field_145850_b, (BlockPos)hitPos, (TileEntity)WorldUtils.getTileEntity((IBlockReader)this.field_145850_b, hitPos));
    }

    protected FloatingLong toFire() {
        return FloatingLong.MAX_VALUE;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        NBTUtils.setFloatingLongIfPresent(nbtTags, "lastFired", value -> {
            this.lastFired = value;
        });
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74778_a("lastFired", this.lastFired.toString());
        return nbtTags;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74778_a("lastFired", this.lastFired.toString());
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setFloatingLongIfPresent(tag, "lastFired", fired -> {
            this.lastFired = fired;
        });
    }

    public LaserEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }
}

