/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.StackedWasteBarrel;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class TileEntityRadioactiveWasteBarrel
extends TileEntityMekanism
implements IConfigurable {
    private static final float TOLERANCE = 0.05f;
    private long lastProcessTick;
    private StackedWasteBarrel gasTank;
    private float prevScale;
    private int processTicks;

    public TileEntityRadioactiveWasteBarrel() {
        super(MekanismBlocks.RADIOACTIVE_WASTE_BARREL);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper builder = ChemicalTankHelper.forSide(this::getDirection);
        this.gasTank = StackedWasteBarrel.create(this);
        builder.addTank(this.gasTank, RelativeSide.TOP, RelativeSide.BOTTOM);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.field_145850_b.func_82737_E() > this.lastProcessTick) {
            float scale;
            this.lastProcessTick = this.field_145850_b.func_82737_E();
            if (MekanismConfig.general.radioactiveWasteBarrelDecayAmount.get() > 0L && !this.gasTank.isEmpty() && !((Gas)this.gasTank.getType()).isIn(MekanismTags.Gases.WASTE_BARREL_DECAY_BLACKLIST) && ++this.processTicks >= MekanismConfig.general.radioactiveWasteBarrelProcessTicks.get()) {
                this.processTicks = 0;
                this.gasTank.shrinkStack(MekanismConfig.general.radioactiveWasteBarrelDecayAmount.get(), Action.EXECUTE);
            }
            if (this.getActive()) {
                ChemicalUtil.emit(EnumSet.of(Direction.DOWN), this.gasTank, (TileEntity)this);
            }
            if (Math.abs((scale = this.getGasScale()) - this.prevScale) > 0.05f) {
                this.sendUpdatePacket();
                this.prevScale = scale;
            }
        }
    }

    public StackedWasteBarrel getGasTank() {
        return this.gasTank;
    }

    public float getGasScale() {
        return (float)((double)this.gasTank.getStored() / (double)this.gasTank.getCapacity());
    }

    public GasStack getGas() {
        return (GasStack)this.gasTank.getStack();
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote()) {
            this.setActive(!this.getActive());
            World world = this.func_145831_w();
            if (world != null) {
                world.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        return ActionResultType.PASS;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_218657_a("gas", (INBT)this.gasTank.serializeNBT());
        updateTag.func_74768_a("progress", this.processTicks);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setCompoundIfPresent(tag, "gas", nbt -> this.gasTank.deserializeNBT((CompoundNBT)nbt));
        NBTUtils.setIntIfPresent(tag, "progress", val -> {
            this.processTicks = val;
        });
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.gasTank.getStored(), this.gasTank.getCapacity());
    }
}

