/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigCardAccess;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.chemical.QuantumEntangloporterChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.QuantumEntangloporterEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.fluid.QuantumEntangloporterFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.heat.QuantumEntangloporterHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.QuantumEntangloporterInventorySlotHolder;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyHandler;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.IProxiedSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileEntityQuantumEntangloporter
extends TileEntityMekanism
implements ISideConfiguration,
IFrequencyHandler,
ISustainedData,
IChunkLoader,
IConfigCardAccess.ISpecialConfigData {
    public final TileComponentEjector ejectorComponent;
    public final TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.FLUID, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.SLURRY, TransmissionType.ENERGY, TransmissionType.HEAT);
    public final TileComponentChunkLoader<TileEntityQuantumEntangloporter> chunkLoaderComponent;
    private double lastTransferLoss;
    private double lastEnvironmentLoss;

    public TileEntityQuantumEntangloporter() {
        super(MekanismBlocks.QUANTUM_ENTANGLOPORTER);
        this.setupConfig(TransmissionType.ITEM, IProxiedSlotInfo.InventoryProxy::new, () -> this.hasFrequency() ? this.getFreq().getInventorySlots(null) : Collections.emptyList());
        this.setupConfig(TransmissionType.FLUID, IProxiedSlotInfo.FluidProxy::new, () -> this.hasFrequency() ? this.getFreq().getFluidTanks(null) : Collections.emptyList());
        this.setupConfig(TransmissionType.GAS, IProxiedSlotInfo.GasProxy::new, () -> this.hasFrequency() ? this.getFreq().getGasTanks(null) : Collections.emptyList());
        this.setupConfig(TransmissionType.INFUSION, IProxiedSlotInfo.InfusionProxy::new, () -> this.hasFrequency() ? this.getFreq().getInfusionTanks(null) : Collections.emptyList());
        this.setupConfig(TransmissionType.PIGMENT, IProxiedSlotInfo.PigmentProxy::new, () -> this.hasFrequency() ? this.getFreq().getPigmentTanks(null) : Collections.emptyList());
        this.setupConfig(TransmissionType.SLURRY, IProxiedSlotInfo.SlurryProxy::new, () -> this.hasFrequency() ? this.getFreq().getSlurryTanks(null) : Collections.emptyList());
        this.setupConfig(TransmissionType.ENERGY, IProxiedSlotInfo.EnergyProxy::new, () -> this.hasFrequency() ? this.getFreq().getEnergyContainers(null) : Collections.emptyList());
        ConfigInfo heatConfig = this.configComponent.getConfig(TransmissionType.HEAT);
        if (heatConfig != null) {
            Supplier<List<IHeatCapacitor>> capacitorSupplier = () -> this.hasFrequency() ? this.getFreq().getHeatCapacitors(null) : Collections.emptyList();
            heatConfig.addSlotInfo(DataType.INPUT_OUTPUT, new IProxiedSlotInfo.HeatProxy(true, false, capacitorSupplier));
            heatConfig.fill(DataType.INPUT_OUTPUT);
            heatConfig.setCanEject(false);
        }
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM, TransmissionType.FLUID, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.SLURRY);
        this.chunkLoaderComponent = new TileComponentChunkLoader<TileEntityQuantumEntangloporter>(this);
        this.frequencyComponent.track(FrequencyType.INVENTORY, true, true, true);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, this));
    }

    private <T> void setupConfig(TransmissionType type, IProxiedSlotInfo.ProxySlotInfoCreator<T> proxyCreator, Supplier<List<T>> supplier) {
        ConfigInfo config = this.configComponent.getConfig(type);
        if (config != null) {
            config.addSlotInfo(DataType.INPUT, proxyCreator.create(true, false, supplier));
            config.addSlotInfo(DataType.OUTPUT, proxyCreator.create(false, true, supplier));
            config.addSlotInfo(DataType.INPUT_OUTPUT, proxyCreator.create(true, true, supplier));
            config.fill(DataType.INPUT);
            config.setDataType(DataType.OUTPUT, RelativeSide.FRONT);
        }
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        return new QuantumEntangloporterChemicalTankHolder<Gas, GasStack, IGasTank>(this, TransmissionType.GAS, InventoryFrequency::getGasTanks);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> getInitialInfusionTanks() {
        return new QuantumEntangloporterChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank>(this, TransmissionType.INFUSION, InventoryFrequency::getInfusionTanks);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Pigment, PigmentStack, IPigmentTank> getInitialPigmentTanks() {
        return new QuantumEntangloporterChemicalTankHolder<Pigment, PigmentStack, IPigmentTank>(this, TransmissionType.PIGMENT, InventoryFrequency::getPigmentTanks);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> getInitialSlurryTanks() {
        return new QuantumEntangloporterChemicalTankHolder<Slurry, SlurryStack, ISlurryTank>(this, TransmissionType.SLURRY, InventoryFrequency::getSlurryTanks);
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        return new QuantumEntangloporterFluidTankHolder(this);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        return new QuantumEntangloporterEnergyContainerHolder(this);
    }

    @Override
    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        return new QuantumEntangloporterHeatCapacitorHolder(this);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        return new QuantumEntangloporterInventorySlotHolder(this);
    }

    @Override
    protected void onUpdateServer() {
        ConfigInfo info;
        super.onUpdateServer();
        if (this.hasFrequency() && (info = this.configComponent.getConfig(TransmissionType.ENERGY)) != null && info.isEjecting()) {
            CableUtils.emit(info.getAllOutputtingSides(), this.getFreq().storedEnergy, (TileEntity)this);
        }
        this.updateHeatCapacitors(null);
        HeatAPI.HeatTransfer loss = this.simulate();
        this.lastTransferLoss = loss.getAdjacentTransfer();
        this.lastEnvironmentLoss = loss.getEnvironmentTransfer();
    }

    public boolean hasFrequency() {
        InventoryFrequency freq = this.getFreq();
        return freq != null && freq.isValid();
    }

    @Override
    public boolean persistInventory() {
        return false;
    }

    @Override
    public boolean persists(SubstanceType type) {
        return false;
    }

    @Override
    @Nullable
    public IHeatHandler getAdjacent(Direction side) {
        ISlotInfo slotInfo;
        if (this.hasFrequency() && (slotInfo = this.configComponent.getSlotInfo(TransmissionType.HEAT, side)) != null && slotInfo.canInput()) {
            TileEntity adj = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(side));
            return CapabilityUtils.getCapability((ICapabilityProvider)adj, Capabilities.HEAT_HANDLER_CAPABILITY, side.func_176734_d()).resolve().orElse(null);
        }
        return null;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public Direction getOrientation() {
        return this.getDirection();
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    public TileComponentChunkLoader<TileEntityQuantumEntangloporter> getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        return Collections.singleton(new ChunkPos(this.func_174877_v()));
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        InventoryFrequency freq = this.frequencyComponent.getFrequency(FrequencyType.INVENTORY);
        if (freq != null) {
            ItemDataUtils.setCompound(itemStack, "frequency", freq.serializeIdentity());
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        Frequency.FrequencyIdentity freq;
        if (!this.isRemote() && (freq = Frequency.FrequencyIdentity.load(FrequencyType.INVENTORY, ItemDataUtils.getCompound(itemStack, "frequency"))) != null) {
            this.setFrequency(FrequencyType.INVENTORY, freq);
        }
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("frequency.name", "frequency.name");
        remap.put("frequency.publicFreq", "frequency.publicFreq");
        return remap;
    }

    public InventoryFrequency getFreq() {
        return (InventoryFrequency)this.getFrequency(FrequencyType.INVENTORY);
    }

    public double getLastTransferLoss() {
        return this.lastTransferLoss;
    }

    public double getLastEnvironmentLoss() {
        return this.lastEnvironmentLoss;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableDouble.create(this::getLastTransferLoss, value -> {
            this.lastTransferLoss = value;
        }));
        container.track(SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
    }

    @Override
    public CompoundNBT getConfigurationData(CompoundNBT nbtTags) {
        InventoryFrequency freq = this.getFreq();
        if (freq != null) {
            nbtTags.func_218657_a("frequency", (INBT)freq.serializeIdentity());
        }
        return nbtTags;
    }

    @Override
    public void setConfigurationData(CompoundNBT nbtTags) {
        Frequency.FrequencyIdentity freq = Frequency.FrequencyIdentity.load(FrequencyType.INVENTORY, nbtTags.func_74775_l("frequency"));
        if (freq != null) {
            this.setFrequency(FrequencyType.INVENTORY, freq);
        } else {
            this.unsetFrequency(FrequencyType.INVENTORY);
        }
    }

    @Override
    public String getDataType() {
        return this.getBlockType().func_149739_a();
    }
}

