/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigCardAccess;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.content.transporter.SorterItemStackFilter;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.list.SyncableFilterList;
import mekanism.common.inventory.slot.InternalInventorySlot;
import mekanism.common.lib.HashList;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IHasSortableFilters;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockReader;

public class TileEntityLogisticalSorter
extends TileEntityMekanism
implements IConfigCardAccess.ISpecialConfigData,
ISustainedData,
ITileFilterHolder<SorterFilter<?>>,
IHasSortableFilters {
    private HashList<SorterFilter<?>> filters = new HashList();
    private final Finder strictFinder = stack -> this.filters.stream().noneMatch(filter -> !filter.allowDefault && filter.getFinder().modifies(stack));
    public EnumColor color;
    public boolean autoEject;
    public boolean roundRobin;
    public boolean singleItem;
    public int rrIndex = 0;
    private int delayTicks;

    public TileEntityLogisticalSorter() {
        super(MekanismBlocks.LOGISTICAL_SORTER);
        this.delaySupplier = () -> 3;
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, this));
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        builder.addSlot(InternalInventorySlot.create(this), RelativeSide.FRONT, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.delayTicks = Math.max(0, this.delayTicks - 1);
        if (this.delayTicks == 6) {
            this.setActive(false);
        }
        if (MekanismUtils.canFunction(this) && this.delayTicks == 0) {
            TileEntity back = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(this.getOppositeDirection()));
            TileEntity front = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(this.getDirection()));
            if (InventoryUtils.isItemHandler(back, this.getDirection()) && front != null) {
                TransitRequest request;
                TransitRequest.TransitResponse response;
                boolean sentItems = false;
                int min = 0;
                for (SorterFilter<?> filter : this.filters) {
                    TransitRequest.TransitResponse response2;
                    TransitRequest request2 = filter.mapInventory(back, this.getDirection(), this.singleItem);
                    if (request2.isEmpty()) continue;
                    if (!this.singleItem && filter instanceof SorterItemStackFilter) {
                        SorterItemStackFilter itemFilter = (SorterItemStackFilter)filter;
                        if (itemFilter.sizeMode) {
                            min = itemFilter.min;
                        }
                    }
                    if ((response2 = this.emitItemToTransporter(front, request2, filter.color, min)).isEmpty()) continue;
                    response2.useAll();
                    WorldUtils.saveChunk(back);
                    this.setActive(true);
                    sentItems = true;
                    break;
                }
                if (!sentItems && this.autoEject && !(response = this.emitItemToTransporter(front, request = TransitRequest.definedItem(back, this.getDirection(), this.singleItem ? 1 : 64, this.strictFinder), this.color, 0)).isEmpty()) {
                    response.useAll();
                    WorldUtils.saveChunk(back);
                    this.setActive(true);
                }
            }
            this.delayTicks = 10;
        }
    }

    private TransitRequest.TransitResponse emitItemToTransporter(TileEntity front, TransitRequest request, EnumColor filterColor, int min) {
        if (front instanceof TileEntityLogisticalTransporterBase) {
            LogisticalTransporterBase transporter = ((TileEntityLogisticalTransporterBase)front).getTransmitter();
            if (this.roundRobin) {
                return transporter.insertRR(this, request, filterColor, true, min);
            }
            return transporter.insert(this, request, filterColor, true, min);
        }
        return request.addToInventory(front, this.getDirection(), false);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        return this.getConfigurationData(nbtTags);
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        this.setConfigurationData(nbtTags);
    }

    @Override
    public void moveUp(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex - 1);
        this.markDirty(false);
    }

    @Override
    public void moveDown(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex + 1);
        this.markDirty(false);
    }

    public void toggleAutoEject() {
        this.autoEject = !this.autoEject;
        this.markDirty(false);
    }

    public void toggleRoundRobin() {
        this.roundRobin = !this.roundRobin;
        this.rrIndex = 0;
        this.markDirty(false);
    }

    public void toggleSingleItem() {
        this.singleItem = !this.singleItem;
        this.markDirty(false);
    }

    public void changeColor(@Nullable EnumColor color) {
        this.color = color;
        this.markDirty(false);
    }

    public boolean canSendHome(ItemStack stack) {
        TileEntity back = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(this.getOppositeDirection()));
        return TransporterUtils.canInsert(back, null, stack, this.getOppositeDirection(), true);
    }

    public boolean hasConnectedInventory() {
        TileEntity tile = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(this.getOppositeDirection()));
        return TransporterUtils.isValidAcceptorOnSide(tile, this.getOppositeDirection());
    }

    @Nonnull
    public TransitRequest.TransitResponse sendHome(TransitRequest request) {
        TileEntity back = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.field_174879_c.func_177972_a(this.getOppositeDirection()));
        return request.addToInventory(back, this.getOppositeDirection(), true);
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public CompoundNBT getConfigurationData(CompoundNBT nbtTags) {
        nbtTags.func_74768_a("color", TransporterUtils.getColorIndex(this.color));
        nbtTags.func_74757_a("eject", this.autoEject);
        nbtTags.func_74757_a("roundRobin", this.roundRobin);
        nbtTags.func_74757_a("singleItem", this.singleItem);
        nbtTags.func_74768_a("index", this.rrIndex);
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (SorterFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            nbtTags.func_218657_a("filters", (INBT)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void setConfigurationData(CompoundNBT nbtTags) {
        NBTUtils.setEnumIfPresent(nbtTags, "color", TransporterUtils::readColor, color -> {
            this.color = color;
        });
        this.autoEject = nbtTags.func_74767_n("eject");
        this.roundRobin = nbtTags.func_74767_n("roundRobin");
        this.singleItem = nbtTags.func_74767_n("singleItem");
        this.rrIndex = nbtTags.func_74762_e("index");
        if (nbtTags.func_150297_b("filters", 9)) {
            ListNBT tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof SorterFilter)) continue;
                this.filters.add((SorterFilter)filter);
            }
        }
    }

    @Override
    public String getDataType() {
        return this.getBlockType().func_149739_a();
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setInt(itemStack, "color", TransporterUtils.getColorIndex(this.color));
        ItemDataUtils.setBoolean(itemStack, "eject", this.autoEject);
        ItemDataUtils.setBoolean(itemStack, "roundRobin", this.roundRobin);
        ItemDataUtils.setBoolean(itemStack, "singleItem", this.singleItem);
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (SorterFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "color", 3)) {
            this.color = TransporterUtils.readColor(ItemDataUtils.getInt(itemStack, "color"));
        }
        this.autoEject = ItemDataUtils.getBoolean(itemStack, "eject");
        this.roundRobin = ItemDataUtils.getBoolean(itemStack, "roundRobin");
        this.singleItem = ItemDataUtils.getBoolean(itemStack, "singleItem");
        if (ItemDataUtils.hasData(itemStack, "filters", 9)) {
            ListNBT tagList = ItemDataUtils.getList(itemStack, "filters");
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof SorterFilter)) continue;
                this.filters.add((SorterFilter)filter);
            }
        }
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("color", "color");
        remap.put("eject", "eject");
        remap.put("roundRobin", "roundRobin");
        remap.put("singleItem", "singleItem");
        remap.put("filters", "filters");
        return remap;
    }

    @Override
    public int getRedstoneLevel() {
        return this.getActive() ? 15 : 0;
    }

    @Override
    public int getCurrentRedstoneLevel() {
        return this.getRedstoneLevel();
    }

    @Override
    public HashList<SorterFilter<?>> getFilters() {
        return this.filters;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(() -> this.autoEject, value -> {
            this.autoEject = value;
        }));
        container.track(SyncableBoolean.create(() -> this.roundRobin, value -> {
            this.roundRobin = value;
        }));
        container.track(SyncableBoolean.create(() -> this.singleItem, value -> {
            this.singleItem = value;
        }));
        container.track(SyncableInt.create(() -> TransporterUtils.getColorIndex(this.color), value -> {
            this.color = TransporterUtils.readColor(value);
        }));
        container.track(SyncableFilterList.create(this::getFilters, value -> {
            this.filters = value instanceof HashList ? (HashList)value : new HashList(value);
        }));
    }
}

