/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tags;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.EnumMap;
import java.util.Map;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.common.Mekanism;
import mekanism.common.resource.OreType;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.util.EnumUtils;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class MekanismTags {
    private MekanismTags() {
    }

    public static class TileEntityTypes {
        public static final ITag.INamedTag<TileEntityType<?>> CARDBOARD_BLACKLIST = TileEntityTypes.tag("cardboard_blacklist");
        public static final ITag.INamedTag<TileEntityType<?>> RELOCATION_NOT_SUPPORTED = TileEntityTypes.forgeTag("relocation_not_supported");
        public static final ITag.INamedTag<TileEntityType<?>> IMMOVABLE = TileEntityTypes.forgeTag("immovable");

        private TileEntityTypes() {
        }

        private static ITag.INamedTag<TileEntityType<?>> tag(String name) {
            return ForgeTagHandler.makeWrapperTag((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (ResourceLocation)Mekanism.rl(name));
        }

        private static ITag.INamedTag<TileEntityType<?>> forgeTag(String name) {
            return ForgeTagHandler.makeWrapperTag((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (ResourceLocation)new ResourceLocation("forge", name));
        }
    }

    public static class Slurries {
        public static final ITag.INamedTag<Slurry> DIRTY = Slurries.tag("dirty");
        public static final ITag.INamedTag<Slurry> CLEAN = Slurries.tag("clean");

        private Slurries() {
        }

        private static ITag.INamedTag<Slurry> tag(String name) {
            return ChemicalTags.SLURRY.tag(Mekanism.rl(name));
        }
    }

    public static class Pigments {
        private Pigments() {
        }

        private static ITag.INamedTag<Pigment> tag(String name) {
            return ChemicalTags.PIGMENT.tag(Mekanism.rl(name));
        }
    }

    public static class InfuseTypes {
        public static final ITag.INamedTag<InfuseType> CARBON = InfuseTypes.tag("carbon");
        public static final ITag.INamedTag<InfuseType> REDSTONE = InfuseTypes.tag("redstone");
        public static final ITag.INamedTag<InfuseType> DIAMOND = InfuseTypes.tag("diamond");
        public static final ITag.INamedTag<InfuseType> REFINED_OBSIDIAN = InfuseTypes.tag("refined_obsidian");
        public static final ITag.INamedTag<InfuseType> BIO = InfuseTypes.tag("bio");
        public static final ITag.INamedTag<InfuseType> FUNGI = InfuseTypes.tag("fungi");
        public static final ITag.INamedTag<InfuseType> GOLD = InfuseTypes.tag("gold");
        public static final ITag.INamedTag<InfuseType> TIN = InfuseTypes.tag("tin");

        private InfuseTypes() {
        }

        private static ITag.INamedTag<InfuseType> tag(String name) {
            return ChemicalTags.INFUSE_TYPE.tag(Mekanism.rl(name));
        }
    }

    public static class Gases {
        public static final ITag.INamedTag<Gas> WATER_VAPOR = Gases.tag("water_vapor");
        public static final ITag.INamedTag<Gas> WASTE_BARREL_DECAY_BLACKLIST = Gases.tag("waste_barrel_decay_blacklist");

        private Gases() {
        }

        private static ITag.INamedTag<Gas> tag(String name) {
            return ChemicalTags.GAS.tag(Mekanism.rl(name));
        }
    }

    public static class Fluids {
        public static final ITag.INamedTag<Fluid> BRINE = Fluids.forgeTag("brine");
        public static final ITag.INamedTag<Fluid> CHLORINE = Fluids.forgeTag("chlorine");
        public static final ITag.INamedTag<Fluid> ETHENE = Fluids.forgeTag("ethene");
        public static final ITag.INamedTag<Fluid> HEAVY_WATER = Fluids.forgeTag("heavy_water");
        public static final ITag.INamedTag<Fluid> HYDROGEN = Fluids.forgeTag("hydrogen");
        public static final ITag.INamedTag<Fluid> HYDROGEN_CHLORIDE = Fluids.forgeTag("hydrogen_chloride");
        public static final ITag.INamedTag<Fluid> LITHIUM = Fluids.forgeTag("lithium");
        public static final ITag.INamedTag<Fluid> OXYGEN = Fluids.forgeTag("oxygen");
        public static final ITag.INamedTag<Fluid> SODIUM = Fluids.forgeTag("sodium");
        public static final ITag.INamedTag<Fluid> STEAM = Fluids.forgeTag("steam");
        public static final ITag.INamedTag<Fluid> SULFUR_DIOXIDE = Fluids.forgeTag("sulfur_dioxide");
        public static final ITag.INamedTag<Fluid> SULFUR_TRIOXIDE = Fluids.forgeTag("sulfur_trioxide");
        public static final ITag.INamedTag<Fluid> SULFURIC_ACID = Fluids.forgeTag("sulfuric_acid");
        public static final ITag.INamedTag<Fluid> HYDROFLUORIC_ACID = Fluids.forgeTag("hydrofluoric_acid");

        private Fluids() {
        }

        private static ITag.INamedTag<Fluid> forgeTag(String name) {
            return FluidTags.func_206956_a((String)("forge:" + name));
        }
    }

    public static class Blocks {
        public static final Map<PrimaryResource, ITag.INamedTag<Block>> RESOURCE_STORAGE_BLOCKS = new EnumMap<PrimaryResource, ITag.INamedTag<Block>>(PrimaryResource.class);
        public static final Map<OreType, ITag.INamedTag<Block>> ORES = new EnumMap<OreType, ITag.INamedTag<Block>>(OreType.class);
        public static final ITag.INamedTag<Block> RELOCATION_NOT_SUPPORTED;
        public static final ITag.INamedTag<Block> CARDBOARD_BLACKLIST;
        public static final ITag.INamedTag<Block> ATOMIC_DISASSEMBLER_ORE;
        public static final ITag.INamedTag<Block> CHESTS_ELECTRIC;
        public static final ITag.INamedTag<Block> CHESTS_PERSONAL;
        public static final ITag.INamedTag<Block> STORAGE_BLOCKS_BRONZE;
        public static final ITag.INamedTag<Block> STORAGE_BLOCKS_CHARCOAL;
        public static final ITag.INamedTag<Block> STORAGE_BLOCKS_REFINED_GLOWSTONE;
        public static final ITag.INamedTag<Block> STORAGE_BLOCKS_REFINED_OBSIDIAN;
        public static final ITag.INamedTag<Block> STORAGE_BLOCKS_STEEL;

        private Blocks() {
        }

        private static ITag.INamedTag<Block> forgeTag(String name) {
            return BlockTags.func_199894_a((String)("forge:" + name));
        }

        private static ITag.INamedTag<Block> tag(String name) {
            return BlockTags.func_199894_a((String)Mekanism.rl(name).toString());
        }

        static {
            for (PrimaryResource primaryResource : EnumUtils.PRIMARY_RESOURCES) {
                if (primaryResource.isVanilla()) continue;
                RESOURCE_STORAGE_BLOCKS.put(primaryResource, Blocks.forgeTag("storage_blocks/" + primaryResource.getName()));
            }
            for (Enum enum_ : EnumUtils.ORE_TYPES) {
                ORES.put((OreType)enum_, Blocks.forgeTag("ores/" + ((OreType)enum_).getResource().getRegistrySuffix()));
            }
            RELOCATION_NOT_SUPPORTED = Blocks.forgeTag("relocation_not_supported");
            CARDBOARD_BLACKLIST = Blocks.tag("cardboard_blacklist");
            ATOMIC_DISASSEMBLER_ORE = Blocks.tag("atomic_disassembler_ore");
            CHESTS_ELECTRIC = Blocks.forgeTag("chests/electric");
            CHESTS_PERSONAL = Blocks.forgeTag("chests/personal");
            STORAGE_BLOCKS_BRONZE = Blocks.forgeTag("storage_blocks/bronze");
            STORAGE_BLOCKS_CHARCOAL = Blocks.forgeTag("storage_blocks/charcoal");
            STORAGE_BLOCKS_REFINED_GLOWSTONE = Blocks.forgeTag("storage_blocks/refined_glowstone");
            STORAGE_BLOCKS_REFINED_OBSIDIAN = Blocks.forgeTag("storage_blocks/refined_obsidian");
            STORAGE_BLOCKS_STEEL = Blocks.forgeTag("storage_blocks/steel");
        }
    }

    public static class Items {
        public static final Table<ResourceType, PrimaryResource, ITag.INamedTag<Item>> PROCESSED_RESOURCES = HashBasedTable.create();
        public static final Map<PrimaryResource, ITag.INamedTag<Item>> PROCESSED_RESOURCE_BLOCKS = new EnumMap<PrimaryResource, ITag.INamedTag<Item>>(PrimaryResource.class);
        public static final Map<OreType, ITag.INamedTag<Item>> ORES = new EnumMap<OreType, ITag.INamedTag<Item>>(OreType.class);
        public static final ITag.INamedTag<Item> CONFIGURATORS;
        public static final ITag.INamedTag<Item> WRENCHES;
        public static final ITag.INamedTag<Item> TOOLS;
        public static final ITag.INamedTag<Item> TOOLS_WRENCH;
        public static final ITag.INamedTag<Item> BATTERIES;
        public static final ITag.INamedTag<Item> RODS_PLASTIC;
        public static final ITag.INamedTag<Item> FUELS;
        public static final ITag.INamedTag<Item> FUELS_BIO;
        public static final ITag.INamedTag<Item> CHESTS_ELECTRIC;
        public static final ITag.INamedTag<Item> CHESTS_PERSONAL;
        public static final ITag.INamedTag<Item> SALT;
        public static final ITag.INamedTag<Item> SAWDUST;
        public static final ITag.INamedTag<Item> YELLOW_CAKE_URANIUM;
        public static final ITag.INamedTag<Item> PELLETS_ANTIMATTER;
        public static final ITag.INamedTag<Item> PELLETS_PLUTONIUM;
        public static final ITag.INamedTag<Item> PELLETS_POLONIUM;
        public static final ITag.INamedTag<Item> DUSTS_BRONZE;
        public static final ITag.INamedTag<Item> DUSTS_CHARCOAL;
        public static final ITag.INamedTag<Item> DUSTS_COAL;
        public static final ITag.INamedTag<Item> DUSTS_DIAMOND;
        public static final ITag.INamedTag<Item> DUSTS_EMERALD;
        public static final ITag.INamedTag<Item> DUSTS_NETHERITE;
        public static final ITag.INamedTag<Item> DUSTS_LAPIS;
        public static final ITag.INamedTag<Item> DUSTS_LITHIUM;
        public static final ITag.INamedTag<Item> DUSTS_OBSIDIAN;
        public static final ITag.INamedTag<Item> DUSTS_QUARTZ;
        public static final ITag.INamedTag<Item> DUSTS_REFINED_OBSIDIAN;
        public static final ITag.INamedTag<Item> DUSTS_SALT;
        public static final ITag.INamedTag<Item> DUSTS_STEEL;
        public static final ITag.INamedTag<Item> DUSTS_SULFUR;
        public static final ITag.INamedTag<Item> DUSTS_WOOD;
        public static final ITag.INamedTag<Item> DUSTS_FLUORITE;
        public static final ITag.INamedTag<Item> NUGGETS_BRONZE;
        public static final ITag.INamedTag<Item> NUGGETS_REFINED_GLOWSTONE;
        public static final ITag.INamedTag<Item> NUGGETS_REFINED_OBSIDIAN;
        public static final ITag.INamedTag<Item> NUGGETS_STEEL;
        public static final ITag.INamedTag<Item> INGOTS_BRONZE;
        public static final ITag.INamedTag<Item> INGOTS_REFINED_GLOWSTONE;
        public static final ITag.INamedTag<Item> INGOTS_REFINED_OBSIDIAN;
        public static final ITag.INamedTag<Item> INGOTS_STEEL;
        public static final ITag.INamedTag<Item> STORAGE_BLOCKS_BRONZE;
        public static final ITag.INamedTag<Item> STORAGE_BLOCKS_CHARCOAL;
        public static final ITag.INamedTag<Item> STORAGE_BLOCKS_REFINED_GLOWSTONE;
        public static final ITag.INamedTag<Item> STORAGE_BLOCKS_REFINED_OBSIDIAN;
        public static final ITag.INamedTag<Item> STORAGE_BLOCKS_STEEL;
        public static final ITag.INamedTag<Item> CIRCUITS;
        public static final ITag.INamedTag<Item> CIRCUITS_BASIC;
        public static final ITag.INamedTag<Item> CIRCUITS_ADVANCED;
        public static final ITag.INamedTag<Item> CIRCUITS_ELITE;
        public static final ITag.INamedTag<Item> CIRCUITS_ULTIMATE;
        public static final ITag.INamedTag<Item> ALLOYS;
        public static final ITag.INamedTag<Item> ALLOYS_BASIC;
        public static final ITag.INamedTag<Item> ALLOYS_INFUSED;
        public static final ITag.INamedTag<Item> ALLOYS_REINFORCED;
        public static final ITag.INamedTag<Item> ALLOYS_ATOMIC;
        public static final ITag.INamedTag<Item> FORGE_ALLOYS;
        public static final ITag.INamedTag<Item> ALLOYS_ADVANCED;
        public static final ITag.INamedTag<Item> ALLOYS_ELITE;
        public static final ITag.INamedTag<Item> ALLOYS_ULTIMATE;
        public static final ITag.INamedTag<Item> ENRICHED;
        public static final ITag.INamedTag<Item> ENRICHED_CARBON;
        public static final ITag.INamedTag<Item> ENRICHED_DIAMOND;
        public static final ITag.INamedTag<Item> ENRICHED_OBSIDIAN;
        public static final ITag.INamedTag<Item> ENRICHED_REDSTONE;
        public static final ITag.INamedTag<Item> ENRICHED_GOLD;
        public static final ITag.INamedTag<Item> ENRICHED_TIN;
        public static final ITag.INamedTag<Item> DIRTY_DUSTS;
        public static final ITag.INamedTag<Item> CLUMPS;
        public static final ITag.INamedTag<Item> SHARDS;
        public static final ITag.INamedTag<Item> CRYSTALS;
        public static final ITag.INamedTag<Item> GEMS_FLUORITE;

        private Items() {
        }

        private static ITag.INamedTag<Item> forgeTag(String name) {
            return ItemTags.func_199901_a((String)("forge:" + name));
        }

        private static ITag.INamedTag<Item> tag(String name) {
            return ItemTags.func_199901_a((String)Mekanism.rl(name).toString());
        }

        static {
            for (PrimaryResource primaryResource : EnumUtils.PRIMARY_RESOURCES) {
                for (ResourceType type : EnumUtils.RESOURCE_TYPES) {
                    if (!type.usedByPrimary()) continue;
                    if (type == ResourceType.INGOT || type == ResourceType.NUGGET || type == ResourceType.DUST) {
                        PROCESSED_RESOURCES.put((Object)type, (Object)primaryResource, Items.forgeTag(type.getPluralPrefix() + "/" + primaryResource.getName()));
                        continue;
                    }
                    PROCESSED_RESOURCES.put((Object)type, (Object)primaryResource, Items.tag(type.getPluralPrefix() + "/" + primaryResource.getName()));
                }
                if (primaryResource.isVanilla()) continue;
                PROCESSED_RESOURCE_BLOCKS.put(primaryResource, Items.forgeTag("storage_blocks/" + primaryResource.getName()));
            }
            for (Enum enum_ : EnumUtils.ORE_TYPES) {
                ORES.put((OreType)enum_, Items.forgeTag("ores/" + ((OreType)enum_).getResource().getRegistrySuffix()));
            }
            CONFIGURATORS = Items.tag("configurators");
            WRENCHES = Items.forgeTag("wrenches");
            TOOLS = Items.forgeTag("tools");
            TOOLS_WRENCH = Items.forgeTag("tools/wrench");
            BATTERIES = Items.forgeTag("batteries");
            RODS_PLASTIC = Items.forgeTag("rods/plastic");
            FUELS = Items.forgeTag("fuels");
            FUELS_BIO = Items.forgeTag("fuels/bio");
            CHESTS_ELECTRIC = Items.forgeTag("chests/electric");
            CHESTS_PERSONAL = Items.forgeTag("chests/personal");
            SALT = Items.forgeTag("salt");
            SAWDUST = Items.forgeTag("sawdust");
            YELLOW_CAKE_URANIUM = Items.forgeTag("yellow_cake_uranium");
            PELLETS_ANTIMATTER = Items.forgeTag("pellets/antimatter");
            PELLETS_PLUTONIUM = Items.forgeTag("pellets/plutonium");
            PELLETS_POLONIUM = Items.forgeTag("pellets/polonium");
            DUSTS_BRONZE = Items.forgeTag("dusts/bronze");
            DUSTS_CHARCOAL = Items.forgeTag("dusts/charcoal");
            DUSTS_COAL = Items.forgeTag("dusts/coal");
            DUSTS_DIAMOND = Items.forgeTag("dusts/diamond");
            DUSTS_EMERALD = Items.forgeTag("dusts/emerald");
            DUSTS_NETHERITE = Items.forgeTag("dusts/netherite");
            DUSTS_LAPIS = Items.forgeTag("dusts/lapis");
            DUSTS_LITHIUM = Items.forgeTag("dusts/lithium");
            DUSTS_OBSIDIAN = Items.forgeTag("dusts/obsidian");
            DUSTS_QUARTZ = Items.forgeTag("dusts/quartz");
            DUSTS_REFINED_OBSIDIAN = Items.forgeTag("dusts/refined_obsidian");
            DUSTS_SALT = Items.forgeTag("dusts/salt");
            DUSTS_STEEL = Items.forgeTag("dusts/steel");
            DUSTS_SULFUR = Items.forgeTag("dusts/sulfur");
            DUSTS_WOOD = Items.forgeTag("dusts/wood");
            DUSTS_FLUORITE = Items.forgeTag("dusts/fluorite");
            NUGGETS_BRONZE = Items.forgeTag("nuggets/bronze");
            NUGGETS_REFINED_GLOWSTONE = Items.forgeTag("nuggets/refined_glowstone");
            NUGGETS_REFINED_OBSIDIAN = Items.forgeTag("nuggets/refined_obsidian");
            NUGGETS_STEEL = Items.forgeTag("nuggets/steel");
            INGOTS_BRONZE = Items.forgeTag("ingots/bronze");
            INGOTS_REFINED_GLOWSTONE = Items.forgeTag("ingots/refined_glowstone");
            INGOTS_REFINED_OBSIDIAN = Items.forgeTag("ingots/refined_obsidian");
            INGOTS_STEEL = Items.forgeTag("ingots/steel");
            STORAGE_BLOCKS_BRONZE = Items.forgeTag("storage_blocks/bronze");
            STORAGE_BLOCKS_CHARCOAL = Items.forgeTag("storage_blocks/charcoal");
            STORAGE_BLOCKS_REFINED_GLOWSTONE = Items.forgeTag("storage_blocks/refined_glowstone");
            STORAGE_BLOCKS_REFINED_OBSIDIAN = Items.forgeTag("storage_blocks/refined_obsidian");
            STORAGE_BLOCKS_STEEL = Items.forgeTag("storage_blocks/steel");
            CIRCUITS = Items.forgeTag("circuits");
            CIRCUITS_BASIC = Items.forgeTag("circuits/basic");
            CIRCUITS_ADVANCED = Items.forgeTag("circuits/advanced");
            CIRCUITS_ELITE = Items.forgeTag("circuits/elite");
            CIRCUITS_ULTIMATE = Items.forgeTag("circuits/ultimate");
            ALLOYS = Items.tag("alloys");
            ALLOYS_BASIC = Items.tag("alloys/basic");
            ALLOYS_INFUSED = Items.tag("alloys/infused");
            ALLOYS_REINFORCED = Items.tag("alloys/reinforced");
            ALLOYS_ATOMIC = Items.tag("alloys/atomic");
            FORGE_ALLOYS = Items.forgeTag("alloys");
            ALLOYS_ADVANCED = Items.forgeTag("alloys/advanced");
            ALLOYS_ELITE = Items.forgeTag("alloys/elite");
            ALLOYS_ULTIMATE = Items.forgeTag("alloys/ultimate");
            ENRICHED = Items.tag("enriched");
            ENRICHED_CARBON = Items.tag("enriched/carbon");
            ENRICHED_DIAMOND = Items.tag("enriched/diamond");
            ENRICHED_OBSIDIAN = Items.tag("enriched/obsidian");
            ENRICHED_REDSTONE = Items.tag("enriched/redstone");
            ENRICHED_GOLD = Items.tag("enriched/gold");
            ENRICHED_TIN = Items.tag("enriched/tin");
            DIRTY_DUSTS = Items.tag("dirty_dusts");
            CLUMPS = Items.tag("clumps");
            SHARDS = Items.tag("shards");
            CRYSTALS = Items.tag("crystals");
            GEMS_FLUORITE = Items.forgeTag("gems/fluorite");
        }
    }
}

