/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.resource;

import mekanism.common.resource.IResource;
import net.minecraft.block.material.PushReaction;

public enum BlockResourceInfo implements IResource
{
    OSMIUM("osmium", 7.5f, 12.0f, 1),
    TIN("tin", 5.0f, 6.0f, 1),
    COPPER("copper", 5.0f, 6.0f, 1),
    LEAD("lead", 5.0f, 9.0f, 1),
    URANIUM("uranium", 5.0f, 9.0f, 1),
    CHARCOAL("charcoal", 5.0f, 6.0f, 0, 16000),
    BRONZE("bronze", 5.0f, 9.0f, 1),
    STEEL("steel", 5.0f, 9.0f, 1),
    REFINED_OBSIDIAN("refined_obsidian", 50.0f, 2400.0f, 2, -1, 8, false, true, PushReaction.BLOCK),
    REFINED_GLOWSTONE("refined_glowstone", 5.0f, 6.0f, 1, -1, 15);

    private final String registrySuffix;
    private final PushReaction pushReaction;
    private final boolean portalFrame;
    private final boolean burnsInFire;
    private final float resistance;
    private final float hardness;
    private final int burnTime;
    private final int lightValue;
    private final int harvestLevel;

    private BlockResourceInfo(String registrySuffix, float hardness, float resistance, int harvestLevel) {
        this(registrySuffix, hardness, resistance, harvestLevel, -1);
    }

    private BlockResourceInfo(String registrySuffix, float hardness, float resistance, int harvestLevel, int burnTime) {
        this(registrySuffix, hardness, resistance, harvestLevel, burnTime, 0);
    }

    private BlockResourceInfo(String registrySuffix, float hardness, float resistance, int harvestLevel, int burnTime, int lightValue) {
        this(registrySuffix, hardness, resistance, harvestLevel, burnTime, lightValue, true, false, PushReaction.NORMAL);
    }

    private BlockResourceInfo(String registrySuffix, float hardness, float resistance, int harvestLevel, int burnTime, int lightValue, boolean burnsInFire, boolean portalFrame, PushReaction pushReaction) {
        this.registrySuffix = registrySuffix;
        this.pushReaction = pushReaction;
        this.portalFrame = portalFrame;
        this.burnsInFire = burnsInFire;
        this.burnTime = burnTime;
        this.lightValue = lightValue;
        this.resistance = resistance;
        this.hardness = hardness;
        this.harvestLevel = harvestLevel;
    }

    @Override
    public String getRegistrySuffix() {
        return this.registrySuffix;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public int getLightValue() {
        return this.lightValue;
    }

    public boolean isPortalFrame() {
        return this.portalFrame;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public boolean burnsInFire() {
        return this.burnsInFire;
    }

    public PushReaction getPushReaction() {
        return this.pushReaction;
    }
}

