/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.container;

import java.util.function.Supplier;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.container.property.PropertyData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateContainer {
    protected final short windowId;
    protected final short property;
    protected final PropertyData data;

    public PacketUpdateContainer(short windowId, short property, PropertyData data) {
        this.windowId = windowId;
        this.property = property;
        this.data = data;
    }

    public static void handle(PacketUpdateContainer message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && player.field_71070_bA instanceof MekanismContainer && player.field_71070_bA.field_75152_c == message.windowId) {
                message.data.handleWindowProperty((MekanismContainer)player.field_71070_bA);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketUpdateContainer pkt, PacketBuffer buffer) {
        buffer.writeByte((int)pkt.windowId);
        buffer.writeShort((int)pkt.property);
        pkt.data.writeToPacket(buffer);
    }

    public static PacketUpdateContainer decode(PacketBuffer buffer) {
        short windowId = buffer.readUnsignedByte();
        short property = buffer.readShort();
        PropertyData data = PropertyData.fromBuffer(buffer);
        return new PacketUpdateContainer(windowId, property, data);
    }
}

