/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.item.interfaces.IRadialModeItem;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRadialModeChange {
    private final EquipmentSlotType slot;
    private final int change;

    public PacketRadialModeChange(EquipmentSlotType slot, int change) {
        this.slot = slot;
        this.change = change;
    }

    public static void handle(PacketRadialModeChange message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ItemStack stack;
            ServerPlayerEntity player = ctx.getSender();
            if (player != null && !(stack = player.func_184582_a(message.slot)).func_190926_b() && stack.func_77973_b() instanceof IRadialModeItem) {
                PacketRadialModeChange.setMode(stack, (IRadialModeItem)stack.func_77973_b(), (PlayerEntity)player, message.change);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static <TYPE extends Enum<TYPE>> void setMode(ItemStack stack, IRadialModeItem<TYPE> item, PlayerEntity player, int index) {
        item.setMode(stack, player, item.getModeByIndex(index));
    }

    public static void encode(PacketRadialModeChange pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.slot);
        buf.func_150787_b(pkt.change);
    }

    public static PacketRadialModeChange decode(PacketBuffer buf) {
        return new PacketRadialModeChange((EquipmentSlotType)buf.func_179257_a(EquipmentSlotType.class), buf.func_150792_a());
    }
}

