/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.client.render.RenderTickHandler;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.network.BasePacketHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketLightningRender {
    private final LightningPreset preset;
    private final Vector3d start;
    private final Vector3d end;
    private final int renderer;
    private final int segments;

    public PacketLightningRender(LightningPreset preset, int renderer, Vector3d start, Vector3d end, int segments) {
        this.preset = preset;
        this.renderer = renderer;
        this.start = start;
        this.end = end;
        this.segments = segments;
    }

    public static void handle(PacketLightningRender message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> RenderTickHandler.renderBolt(message.renderer, message.preset.boltCreator.create(message.start, message.end, message.segments)));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketLightningRender pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.preset);
        buf.func_150787_b(pkt.renderer);
        BasePacketHandler.writeVector3d(buf, pkt.start);
        BasePacketHandler.writeVector3d(buf, pkt.end);
        buf.func_150787_b(pkt.segments);
    }

    public static PacketLightningRender decode(PacketBuffer buf) {
        LightningPreset preset = (LightningPreset)buf.func_179257_a(LightningPreset.class);
        int renderer = buf.func_150792_a();
        Vector3d start = BasePacketHandler.readVector3d(buf);
        Vector3d end = BasePacketHandler.readVector3d(buf);
        int segments = buf.func_150792_a();
        return new PacketLightningRender(preset, renderer, start, end, segments);
    }

    public static enum LightningPreset {
        MAGNETIC_ATTRACTION((start, end, segments) -> new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, start, end, segments).size(0.04f).lifespan(8).spawn(BoltEffect.SpawnFunction.noise(8.0f, 4.0f))),
        TOOL_AOE((start, end, segments) -> new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, start, end, segments).size(0.015f).lifespan(12).spawn(BoltEffect.SpawnFunction.NO_DELAY));

        private final BoltCreator boltCreator;

        private LightningPreset(BoltCreator boltCreator) {
            this.boltCreator = boltCreator;
        }
    }

    @FunctionalInterface
    public static interface BoltCreator {
        public BoltEffect create(Vector3d var1, Vector3d var2, int var3);
    }
}

