/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.common.Mekanism;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TransmitterNetworkRegistry {
    private static final TransmitterNetworkRegistry INSTANCE = new TransmitterNetworkRegistry();
    private static boolean loaderRegistered = false;
    private final Set<DynamicNetwork<?, ?, ?>> networks = new ObjectOpenHashSet();
    private final Set<DynamicNetwork<?, ?, ?>> networksToChange = new ObjectOpenHashSet();
    private final Set<Transmitter<?, ?, ?>> invalidTransmitters = new ObjectOpenHashSet();
    private Map<Coord4D, Transmitter<?, ?, ?>> orphanTransmitters = new Object2ObjectOpenHashMap();
    private final Map<Coord4D, Transmitter<?, ?, ?>> newOrphanTransmitters = new Object2ObjectOpenHashMap();
    private final Map<UUID, DynamicNetwork<?, ?, ?>> clientNetworks = new Object2ObjectOpenHashMap();

    public void addClientNetwork(UUID networkID, DynamicNetwork<?, ?, ?> network) {
        if (!this.clientNetworks.containsKey(networkID)) {
            this.clientNetworks.put(networkID, network);
        }
    }

    @Nullable
    public DynamicNetwork<?, ?, ?> getClientNetwork(UUID networkID) {
        return this.clientNetworks.get(networkID);
    }

    public void removeClientNetwork(DynamicNetwork<?, ?, ?> network) {
        this.clientNetworks.remove(network.getUUID());
    }

    public void clearClientNetworks() {
        this.clientNetworks.clear();
    }

    public static void initiate() {
        if (!loaderRegistered) {
            loaderRegistered = true;
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }
    }

    public static void reset() {
        TransmitterNetworkRegistry.getInstance().networks.clear();
        TransmitterNetworkRegistry.getInstance().networksToChange.clear();
        TransmitterNetworkRegistry.getInstance().invalidTransmitters.clear();
        TransmitterNetworkRegistry.getInstance().orphanTransmitters.clear();
        TransmitterNetworkRegistry.getInstance().newOrphanTransmitters.clear();
    }

    public static void invalidateTransmitter(Transmitter<?, ?, ?> transmitter) {
        TransmitterNetworkRegistry.getInstance().invalidTransmitters.add(transmitter);
    }

    public static void registerOrphanTransmitter(Transmitter<?, ?, ?> transmitter) {
        Coord4D coord = Coord4D.get(transmitter.getTransmitterTile());
        Transmitter<?, ?, ?> previous = TransmitterNetworkRegistry.getInstance().newOrphanTransmitters.put(coord, transmitter);
        if (previous != null && previous != transmitter) {
            Mekanism.logger.error("Different orphan transmitter was already registered at location! {}", (Object)coord);
        }
    }

    public static void registerChangedNetwork(DynamicNetwork<?, ?, ?> network) {
        TransmitterNetworkRegistry.getInstance().networksToChange.add(network);
    }

    public static TransmitterNetworkRegistry getInstance() {
        return INSTANCE;
    }

    public void registerNetwork(DynamicNetwork<?, ?, ?> network) {
        this.networks.add(network);
    }

    public void removeNetwork(DynamicNetwork<?, ?, ?> network) {
        this.networks.remove(network);
        this.networksToChange.remove(network);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            this.removeInvalidTransmitters();
            this.assignOrphans();
            this.commitChanges();
            for (DynamicNetwork<?, ?, ?> net : this.networks) {
                net.onUpdate();
            }
        }
    }

    private void removeInvalidTransmitters() {
        if (MekanismAPI.debug && !this.invalidTransmitters.isEmpty()) {
            Mekanism.logger.info("Dealing with {} invalid Transmitters", (Object)this.invalidTransmitters.size());
        }
        for (Transmitter<?, ?, ?> invalid : this.invalidTransmitters) {
            this.removeInvalidTransmitter(invalid);
        }
        this.invalidTransmitters.clear();
    }

    private <NETWORK extends DynamicNetwork<?, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<?, NETWORK, TRANSMITTER>> void removeInvalidTransmitter(Transmitter<?, NETWORK, TRANSMITTER> invalid) {
        NETWORK n;
        if (!(invalid.isOrphan() && invalid.isValid() || (n = invalid.getTransmitterNetwork()) == null)) {
            ((DynamicNetwork)n).invalidate(invalid);
        }
    }

    private void assignOrphans() {
        this.orphanTransmitters = new Object2ObjectOpenHashMap(this.newOrphanTransmitters);
        this.newOrphanTransmitters.clear();
        if (MekanismAPI.debug && !this.orphanTransmitters.isEmpty()) {
            Mekanism.logger.info("Dealing with {} orphan Transmitters", (Object)this.orphanTransmitters.size());
        }
        for (Transmitter<?, ?, ?> orphanTransmitter : this.orphanTransmitters.values()) {
            if (!orphanTransmitter.isValid() || !orphanTransmitter.isOrphan()) continue;
            OrphanPathFinder finder = orphanTransmitter instanceof BufferedTransmitter ? new BufferedOrphanPathFinder((BufferedTransmitter)orphanTransmitter) : new OrphanPathFinder(orphanTransmitter);
            DynamicNetwork<?, ?, ?> network = this.getNetworkFromOrphan(finder);
            this.networksToChange.add(network);
            network.register();
        }
        this.orphanTransmitters.clear();
    }

    private <ACCEPTOR, NETWORK extends DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<ACCEPTOR, NETWORK, TRANSMITTER>> DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER> getNetworkFromOrphan(OrphanPathFinder<ACCEPTOR, NETWORK, TRANSMITTER> finder) {
        Object network;
        finder.start();
        switch (finder.networksFound.size()) {
            case 0: {
                if (MekanismAPI.debug) {
                    Mekanism.logger.info("No networks found. Creating new network for {} transmitters", (Object)finder.connectedTransmitters.size());
                }
                network = finder.createEmptyNetwork();
                break;
            }
            case 1: {
                if (MekanismAPI.debug) {
                    Mekanism.logger.info("Adding {} transmitters to single found network", (Object)finder.connectedTransmitters.size());
                }
                network = (DynamicNetwork)finder.networksFound.iterator().next();
                break;
            }
            default: {
                if (MekanismAPI.debug) {
                    Mekanism.logger.info("Merging {} networks with {} new transmitters", (Object)finder.networksFound.size(), (Object)finder.connectedTransmitters.size());
                }
                network = finder.createNetworkByMerging();
            }
        }
        ((DynamicNetwork)network).addNewTransmitters(finder.connectedTransmitters);
        return network;
    }

    private void commitChanges() {
        ObjectOpenHashSet networks = new ObjectOpenHashSet(this.networksToChange);
        this.networksToChange.clear();
        for (DynamicNetwork network : networks) {
            network.commit();
        }
    }

    public String toString() {
        return "Network Registry:\n" + this.networks;
    }

    public ITextComponent[] toComponents() {
        ITextComponent[] components = new ITextComponent[this.networks.size()];
        int i = 0;
        for (DynamicNetwork<?, ?, ?> network : this.networks) {
            components[i++] = network.getTextComponent();
        }
        return components;
    }

    public class BufferedOrphanPathFinder<ACCEPTOR, NETWORK extends DynamicBufferedNetwork<ACCEPTOR, NETWORK, BUFFER, TRANSMITTER>, BUFFER, TRANSMITTER extends BufferedTransmitter<ACCEPTOR, NETWORK, BUFFER, TRANSMITTER>>
    extends OrphanPathFinder<ACCEPTOR, NETWORK, TRANSMITTER> {
        protected BufferedOrphanPathFinder(BufferedTransmitter<ACCEPTOR, NETWORK, BUFFER, TRANSMITTER> start) {
            super(start);
        }

        @Override
        public void addNetworkToIterated(BlockPos from) {
            DynamicBufferedNetwork net = (DynamicBufferedNetwork)((BufferedTransmitter)this.startPoint).getExternalNetwork(from);
            if (net != null && net.compatibleWithBuffer(((BufferedTransmitter)this.startPoint).getShare()) && (this.networksFound.isEmpty() || this.networksFound.stream().allMatch(network -> network.isCompatibleWith(net)))) {
                this.networksFound.add(net);
            }
        }
    }

    public class OrphanPathFinder<ACCEPTOR, NETWORK extends DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<ACCEPTOR, NETWORK, TRANSMITTER>> {
        public final Set<TRANSMITTER> connectedTransmitters = new ObjectOpenHashSet();
        public final Set<NETWORK> networksFound = new ObjectOpenHashSet();
        public final Set<BlockPos> iterated = new ObjectOpenHashSet();
        private final Deque<BlockPos> queue = new LinkedList<BlockPos>();
        public final TRANSMITTER startPoint;
        private final World world;

        protected OrphanPathFinder(Transmitter<ACCEPTOR, NETWORK, TRANSMITTER> start) {
            this.startPoint = start;
            this.world = ((Transmitter)this.startPoint).getTileWorld();
        }

        public void start() {
            if (this.queue.peek() != null) {
                Mekanism.logger.error("OrphanPathFinder queue was not empty?!");
                this.queue.clear();
            }
            this.queue.push(((Transmitter)this.startPoint).getTilePos());
            while (this.queue.peek() != null) {
                this.iterate(this.queue.removeFirst());
            }
        }

        public void iterate(BlockPos from) {
            if (this.iterated.add(from)) {
                Coord4D fromCoord = new Coord4D(from, this.world);
                if (TransmitterNetworkRegistry.this.orphanTransmitters.containsKey(fromCoord)) {
                    Transmitter transmitter = (Transmitter)TransmitterNetworkRegistry.this.orphanTransmitters.get(fromCoord);
                    if (transmitter.isValid() && transmitter.isOrphan() && (this.connectedTransmitters.isEmpty() || this.connectedTransmitters.stream().anyMatch(existing -> existing.isValidTransmitter(transmitter)))) {
                        this.connectedTransmitters.add(transmitter);
                        transmitter.setOrphan(false);
                        for (Direction direction : EnumUtils.DIRECTIONS) {
                            BlockPos directionPos;
                            if (direction.func_176740_k().func_176722_c() && !WorldUtils.isBlockLoaded((IBlockReader)this.world, from.func_177972_a(direction)) || (directionPos = transmitter.getAdjacentConnectableTransmitterPos(direction)) == null || this.iterated.contains(directionPos)) continue;
                            this.queue.addLast(directionPos);
                        }
                    }
                } else {
                    this.addNetworkToIterated(from);
                }
            }
        }

        public void addNetworkToIterated(BlockPos from) {
            Object net = ((Transmitter)this.startPoint).getExternalNetwork(from);
            if (net != null) {
                this.networksFound.add(net);
            }
        }

        public NETWORK createEmptyNetwork() {
            return ((Transmitter)this.startPoint).createEmptyNetwork();
        }

        public NETWORK createNetworkByMerging() {
            return ((Transmitter)this.startPoint).createNetworkByMerging(this.networksFound);
        }
    }
}

