/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import mekanism.common.Mekanism;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.util.InventoryUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.items.IItemHandler;

public class TileTransitRequest
extends TransitRequest {
    private final TileEntity tile;
    private final Direction side;
    private final Map<HashedItem, TileItemData> itemMap = new LinkedHashMap<HashedItem, TileItemData>();

    public TileTransitRequest(TileEntity tile, Direction side) {
        this.tile = tile;
        this.side = side;
    }

    public void addItem(ItemStack stack, int slot) {
        HashedItem hashed = HashedItem.create(stack);
        this.itemMap.computeIfAbsent(hashed, x$0 -> new TileItemData((HashedItem)x$0)).addSlot(slot, stack);
    }

    public int getCount(HashedItem itemType) {
        TransitRequest.ItemData data = this.itemMap.get(itemType);
        return data != null ? data.getTotalCount() : 0;
    }

    public Map<HashedItem, TileItemData> getItemMap() {
        return this.itemMap;
    }

    public Collection<TileItemData> getItemData() {
        return this.itemMap.values();
    }

    public class TileItemData
    extends TransitRequest.ItemData {
        private final Int2IntMap slotMap;

        public TileItemData(HashedItem itemType) {
            super(itemType);
            this.slotMap = new Int2IntOpenHashMap();
        }

        public void addSlot(int id, ItemStack stack) {
            this.slotMap.put(id, stack.func_190916_E());
            this.totalCount += stack.func_190916_E();
        }

        @Override
        public ItemStack use(int amount) {
            IItemHandler handler = InventoryUtils.assertItemHandler("TileTransitRequest", TileTransitRequest.this.tile, TileTransitRequest.this.side);
            if (handler != null) {
                ObjectIterator iterator = this.slotMap.int2IntEntrySet().iterator();
                while (iterator.hasNext()) {
                    Int2IntMap.Entry entry = (Int2IntMap.Entry)iterator.next();
                    int currentCount = entry.getIntValue();
                    int toUse = Math.min(amount, currentCount);
                    ItemStack ret = handler.extractItem(entry.getIntKey(), toUse, false);
                    boolean stackable = InventoryUtils.areItemsStackable(this.getItemType().getStack(), ret);
                    if (!stackable || ret.func_190916_E() != toUse) {
                        Mekanism.logger.warn("An inventory's returned content {} does not line up with TileTransitRequest's prediction.", (Object)(!stackable ? "type" : "count"));
                        Mekanism.logger.warn("TileTransitRequest item: {}, toUse: {}, ret: {}", (Object)this.getItemType().getStack(), (Object)toUse, (Object)ret);
                        Mekanism.logger.warn("Tile: {} {}", (Object)TileTransitRequest.this.tile.func_200662_C().getRegistryName(), (Object)TileTransitRequest.this.tile.func_174877_v());
                    }
                    amount -= toUse;
                    this.totalCount -= toUse;
                    if (this.totalCount == 0) {
                        TileTransitRequest.this.itemMap.remove(this.getItemType());
                    }
                    entry.setValue(currentCount -= toUse);
                    if (currentCount == 0) {
                        iterator.remove();
                    }
                    if (amount != 0) continue;
                    break;
                }
            }
            return this.getStack();
        }
    }
}

