/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.item.RateLimitGasHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.interfaces.IGasItem;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemCanteen
extends Item
implements IGasItem {
    public ItemCanteen(Item.Properties properties) {
        super(properties.func_208103_a(Rarity.UNCOMMON).func_200917_a(1).setNoRepair());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        StorageUtils.addStoredGas(stack, tooltip, true, false, MekanismLang.EMPTY);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return StorageUtils.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ChemicalUtil.getRGBDurabilityForDisplay(stack);
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (this.func_194125_a(group)) {
            items.add((Object)ChemicalUtil.getFilledVariant(new ItemStack((IItemProvider)this), MekanismConfig.gear.canteenMaxStorage.get(), MekanismGases.NUTRITIONAL_PASTE));
        }
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull LivingEntity entityLiving) {
        PlayerEntity player;
        long needed;
        if (!world.field_72995_K && entityLiving instanceof PlayerEntity && (needed = Math.min((long)(20 - (player = (PlayerEntity)entityLiving).func_71024_bL().func_75116_a()), this.getGas(stack).getAmount() / (long)MekanismConfig.general.nutritionalPasteMBPerFood.get())) > 0L) {
            player.func_71024_bL().func_75122_a((int)needed, MekanismConfig.general.nutritionalPasteSaturation.get());
            this.useGas(stack, needed * (long)MekanismConfig.general.nutritionalPasteMBPerFood.get());
        }
        return stack;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return 32;
    }

    @Nonnull
    public UseAction func_77661_b(@Nonnull ItemStack stack) {
        return UseAction.DRINK;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, RateLimitGasHandler.create(MekanismConfig.gear.canteenTransferRate, MekanismConfig.gear.canteenMaxStorage, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrueBi, gas -> gas == MekanismGases.NUTRITIONAL_PASTE.getChemical()));
    }

    private GasStack getGas(ItemStack stack) {
        Optional capability = stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve();
        if (capability.isPresent()) {
            IGasTank gasTank;
            IGasHandler gasHandlerItem = (IGasHandler)capability.get();
            if (gasHandlerItem instanceof IGasHandler.IMekanismGasHandler && (gasTank = (IGasTank)((IGasHandler.IMekanismGasHandler)gasHandlerItem).getChemicalTank(0, null)) != null) {
                return (GasStack)gasTank.getStack();
            }
            return (GasStack)gasHandlerItem.getChemicalInTank(0);
        }
        return GasStack.EMPTY;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        if (!playerIn.func_184812_l_() && playerIn.func_71043_e(false) && this.getGas(playerIn.func_184586_b(handIn)).getAmount() >= 50L) {
            playerIn.func_184598_c(handIn);
        }
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }
}

