/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot.chemical;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.inventory.AutomationType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.inventory.slot.chemical.InfusionInventorySlot;
import mekanism.common.inventory.slot.chemical.PigmentInventorySlot;
import mekanism.common.inventory.slot.chemical.SlurryInventorySlot;
import net.minecraft.item.ItemStack;

public class MergedChemicalInventorySlot<MERGED extends MergedChemicalTank>
extends BasicInventorySlot {
    protected final MERGED mergedTank;

    private static boolean hasCapability(@Nonnull ItemStack stack) {
        return stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent() || stack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).isPresent() || stack.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY).isPresent() || stack.getCapability(Capabilities.SLURRY_HANDLER_CAPABILITY).isPresent();
    }

    public static MergedChemicalInventorySlot<MergedChemicalTank> drain(MergedChemicalTank chemicalTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(chemicalTank, "Merged chemical tank cannot be null");
        Predicate<@NonNull ItemStack> gasInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank.getGasTank(), GasInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> infusionInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank.getInfusionTank(), InfusionInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> pigmentInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank.getPigmentTank(), PigmentInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> slurryInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank.getSlurryTank(), SlurryInventorySlot::getCapability);
        BiPredicate<@NonNull ItemStack, @NonNull AutomationType> insertPredicate = (stack, automationType) -> {
            MergedChemicalTank.Current current = chemicalTank.getCurrent();
            if (current == MergedChemicalTank.Current.GAS) {
                return gasInsertPredicate.test((ItemStack)stack);
            }
            if (current == MergedChemicalTank.Current.INFUSION) {
                return infusionInsertPredicate.test((ItemStack)stack);
            }
            if (current == MergedChemicalTank.Current.PIGMENT) {
                return pigmentInsertPredicate.test((ItemStack)stack);
            }
            if (current == MergedChemicalTank.Current.SLURRY) {
                return slurryInsertPredicate.test((ItemStack)stack);
            }
            return gasInsertPredicate.test((ItemStack)stack) || infusionInsertPredicate.test((ItemStack)stack) || pigmentInsertPredicate.test((ItemStack)stack) || slurryInsertPredicate.test((ItemStack)stack);
        };
        return new MergedChemicalInventorySlot<MergedChemicalTank>(chemicalTank, (stack, automationType) -> automationType == AutomationType.MANUAL || !insertPredicate.test((ItemStack)stack, (AutomationType)((Object)automationType)), insertPredicate, MergedChemicalInventorySlot::hasCapability, listener, x, y);
    }

    public static MergedChemicalInventorySlot<MergedChemicalTank> fill(MergedChemicalTank chemicalTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(chemicalTank, "Merged chemical tank cannot be null");
        Predicate<@NonNull ItemStack> gasExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(chemicalTank.getGasTank(), GasInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> infusionExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(chemicalTank.getInfusionTank(), InfusionInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> pigmentExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(chemicalTank.getPigmentTank(), PigmentInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> slurryExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(chemicalTank.getSlurryTank(), SlurryInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> gasInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank.getGasTank(), GasInventorySlot.getCapability(stack));
        Predicate<@NonNull ItemStack> infusionInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank.getInfusionTank(), InfusionInventorySlot.getCapability(stack));
        Predicate<@NonNull ItemStack> pigmentInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank.getPigmentTank(), PigmentInventorySlot.getCapability(stack));
        Predicate<@NonNull ItemStack> slurryInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank.getSlurryTank(), SlurryInventorySlot.getCapability(stack));
        return new MergedChemicalInventorySlot<MergedChemicalTank>(chemicalTank, (stack, automationType) -> {
            if (automationType == AutomationType.MANUAL) {
                return true;
            }
            MergedChemicalTank.Current current = chemicalTank.getCurrent();
            if (current == MergedChemicalTank.Current.GAS) {
                return gasExtractPredicate.test((ItemStack)stack);
            }
            if (current == MergedChemicalTank.Current.INFUSION) {
                return infusionExtractPredicate.test((ItemStack)stack);
            }
            if (current == MergedChemicalTank.Current.PIGMENT) {
                return pigmentExtractPredicate.test((ItemStack)stack);
            }
            if (current == MergedChemicalTank.Current.SLURRY) {
                return slurryExtractPredicate.test((ItemStack)stack);
            }
            return gasExtractPredicate.test((ItemStack)stack) && infusionExtractPredicate.test((ItemStack)stack) && pigmentExtractPredicate.test((ItemStack)stack) && slurryExtractPredicate.test((ItemStack)stack);
        }, (stack, automationType) -> {
            MergedChemicalTank.Current current = chemicalTank.getCurrent();
            if (current == MergedChemicalTank.Current.GAS) {
                return gasInsertPredicate.test((ItemStack)stack);
            }
            if (current == MergedChemicalTank.Current.INFUSION) {
                return infusionInsertPredicate.test((ItemStack)stack);
            }
            if (current == MergedChemicalTank.Current.PIGMENT) {
                return pigmentInsertPredicate.test((ItemStack)stack);
            }
            if (current == MergedChemicalTank.Current.SLURRY) {
                return slurryInsertPredicate.test((ItemStack)stack);
            }
            return gasInsertPredicate.test((ItemStack)stack) || infusionInsertPredicate.test((ItemStack)stack) || pigmentInsertPredicate.test((ItemStack)stack) || slurryInsertPredicate.test((ItemStack)stack);
        }, MergedChemicalInventorySlot::hasCapability, listener, x, y);
    }

    protected MergedChemicalInventorySlot(MERGED mergedTank, BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canExtract, BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, validator, listener, x, y);
        this.mergedTank = mergedTank;
    }

    public void drainChemicalTanks() {
        this.drainChemicalTank(MergedTank.CurrentType.GAS);
        this.drainChemicalTank(MergedTank.CurrentType.INFUSION);
        this.drainChemicalTank(MergedTank.CurrentType.PIGMENT);
        this.drainChemicalTank(MergedTank.CurrentType.SLURRY);
    }

    public void drainChemicalTank(MergedTank.CurrentType type) {
        if (type == MergedTank.CurrentType.GAS) {
            ChemicalInventorySlot.drainChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getGasTank(), GasInventorySlot.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.INFUSION) {
            ChemicalInventorySlot.drainChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getInfusionTank(), InfusionInventorySlot.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.PIGMENT) {
            ChemicalInventorySlot.drainChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getPigmentTank(), PigmentInventorySlot.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.SLURRY) {
            ChemicalInventorySlot.drainChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getSlurryTank(), SlurryInventorySlot.getCapability(this.current));
        }
    }

    public void fillChemicalTanks() {
        this.fillChemicalTank(MergedTank.CurrentType.GAS);
        this.fillChemicalTank(MergedTank.CurrentType.INFUSION);
        this.fillChemicalTank(MergedTank.CurrentType.PIGMENT);
        this.fillChemicalTank(MergedTank.CurrentType.SLURRY);
    }

    public void fillChemicalTank(MergedTank.CurrentType type) {
        if (type == MergedTank.CurrentType.GAS) {
            ChemicalInventorySlot.fillChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getGasTank(), GasInventorySlot.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.INFUSION) {
            ChemicalInventorySlot.fillChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getInfusionTank(), InfusionInventorySlot.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.PIGMENT) {
            ChemicalInventorySlot.fillChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getPigmentTank(), PigmentInventorySlot.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.SLURRY) {
            ChemicalInventorySlot.fillChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getSlurryTank(), SlurryInventorySlot.getCapability(this.current));
        }
    }
}

