/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSInfuseType;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;

@RecipeTypeMapper
public class MetallurgicInfuserRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekMetallurgicInfuser";
    }

    public String getDescription() {
        return "Maps Mekanism metallurgic infuser recipes.";
    }

    public boolean canHandle(IRecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.METALLURGIC_INFUSING;
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, IRecipe<?> iRecipe, INSSFakeGroupManager groupManager) {
        if (!(iRecipe instanceof MetallurgicInfuserRecipe)) {
            return false;
        }
        boolean handled = false;
        MetallurgicInfuserRecipe recipe = (MetallurgicInfuserRecipe)iRecipe;
        List<@NonNull TYPE> infuseTypeRepresentations = recipe.getInfusionInput().getRepresentations();
        List<@NonNull TYPE> itemRepresentations = recipe.getItemInput().getRepresentations();
        for (InfusionStack infuseTypeRepresentation : infuseTypeRepresentations) {
            NSSInfuseType nssInfuseType = NSSInfuseType.createInfuseType(infuseTypeRepresentation);
            for (ItemStack itemRepresentation : itemRepresentations) {
                ItemStack output = recipe.getOutput(infuseTypeRepresentation, itemRepresentation);
                if (output.func_190926_b()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put((NormalizedSimpleStack)nssInfuseType, infuseTypeRepresentation.getAmount());
                ingredientHelper.put(itemRepresentation);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

