/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.energy.IEnergyCompat;
import mekanism.common.integration.energy.StrictEnergyCompat;
import mekanism.common.integration.energy.fluxnetworks.FNEnergyCompat;
import mekanism.common.integration.energy.forgeenergy.ForgeEnergyCompat;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class EnergyCompatUtils {
    private static final List<IEnergyCompat> energyCompats = Collections.unmodifiableList(Arrays.asList(new StrictEnergyCompat(), new FNEnergyCompat(), new ForgeEnergyCompat()));

    private EnergyCompatUtils() {
    }

    public static List<IEnergyCompat> getCompats() {
        return energyCompats;
    }

    public static boolean isEnergyCapability(Capability<?> capability) {
        if (capability == null) {
            return false;
        }
        for (IEnergyCompat energyCompat : energyCompats) {
            if (!energyCompat.isMatchingCapability(capability)) continue;
            return energyCompat.isUsable();
        }
        return false;
    }

    public static List<Capability<?>> getEnabledEnergyCapabilities() {
        return energyCompats.stream().filter(IEnergyCompat::isUsable).map(IEnergyCompat::getCapability).collect(Collectors.toList());
    }

    private static boolean isTileValid(@Nullable TileEntity tile) {
        return tile != null && !tile.func_145837_r() && tile.func_145830_o();
    }

    public static boolean hasStrictEnergyHandler(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && EnergyCompatUtils.hasStrictEnergyHandler((ICapabilityProvider)stack, null);
    }

    public static boolean hasStrictEnergyHandler(@Nullable TileEntity tile, Direction side) {
        return EnergyCompatUtils.isTileValid(tile) && EnergyCompatUtils.hasStrictEnergyHandler((ICapabilityProvider)tile, side);
    }

    private static boolean hasStrictEnergyHandler(ICapabilityProvider provider, Direction side) {
        for (IEnergyCompat energyCompat : energyCompats) {
            if (!energyCompat.isUsable() || !energyCompat.isCapabilityPresent(provider, side)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static IStrictEnergyHandler getStrictEnergyHandler(@Nonnull ItemStack stack) {
        return EnergyCompatUtils.getLazyStrictEnergyHandler(stack).resolve().orElse(null);
    }

    @Nonnull
    public static LazyOptional<IStrictEnergyHandler> getLazyStrictEnergyHandler(@Nonnull ItemStack stack) {
        return stack.func_190926_b() ? LazyOptional.empty() : EnergyCompatUtils.getLazyStrictEnergyHandler((ICapabilityProvider)stack, null);
    }

    @Nonnull
    public static LazyOptional<IStrictEnergyHandler> getLazyStrictEnergyHandler(@Nullable TileEntity tile, Direction side) {
        return EnergyCompatUtils.isTileValid(tile) ? EnergyCompatUtils.getLazyStrictEnergyHandler((ICapabilityProvider)tile, side) : LazyOptional.empty();
    }

    @Nonnull
    private static LazyOptional<IStrictEnergyHandler> getLazyStrictEnergyHandler(ICapabilityProvider provider, Direction side) {
        for (IEnergyCompat energyCompat : energyCompats) {
            LazyOptional<IStrictEnergyHandler> handler;
            if (!energyCompat.isUsable() || !(handler = energyCompat.getLazyStrictEnergyHandler(provider, side)).isPresent()) continue;
            return handler;
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public static <T> LazyOptional<T> getEnergyCapability(Capability<T> capability, @Nonnull IStrictEnergyHandler handler) {
        if (capability == null) {
            return LazyOptional.empty();
        }
        for (IEnergyCompat energyCompat : energyCompats) {
            if (!energyCompat.isUsable() || !energyCompat.isMatchingCapability(capability)) continue;
            return energyCompat.getHandlerAs(handler).cast();
        }
        return LazyOptional.empty();
    }

    private static boolean useIC2() {
        return Mekanism.hooks.IC2Loaded && !MekanismConfig.general.blacklistIC2.get();
    }

    public static enum EnergyType {
        FORGE(MekanismConfig.general.FROM_FORGE, MekanismConfig.general.TO_FORGE),
        EU(MekanismConfig.general.FROM_IC2, MekanismConfig.general.TO_IC2);

        private final FloatingLongSupplier fromSupplier;
        private final FloatingLongSupplier toSupplier;

        private EnergyType(FloatingLongSupplier fromSupplier, FloatingLongSupplier toSupplier) {
            this.fromSupplier = fromSupplier;
            this.toSupplier = toSupplier;
        }

        public FloatingLong convertFrom(long energy) {
            return this.fromSupplier.get().multiply(energy);
        }

        public FloatingLong convertFrom(FloatingLong energy) {
            return energy.multiply(this.fromSupplier.get());
        }

        public int convertToAsInt(FloatingLong joules) {
            return this.convertToAsFloatingLong(joules).intValue();
        }

        public long convertToAsLong(FloatingLong joules) {
            return this.convertToAsFloatingLong(joules).longValue();
        }

        public FloatingLong convertToAsFloatingLong(FloatingLong joules) {
            return joules.multiply(this.toSupplier.get());
        }
    }
}

