/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.DataHandlerUtils;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.content.network.HeatNetwork;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.Color;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.tier.ConductorTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.ThermodynamicConductorUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

public class ThermodynamicConductor
extends Transmitter<IHeatHandler, HeatNetwork, ThermodynamicConductor>
implements ITileHeatHandler,
IUpgradeableTransmitter<ThermodynamicConductorUpgradeData> {
    public final ConductorTier tier;
    private double clientTemperature = 300.0;
    private final List<IHeatCapacitor> capacitors;
    public final BasicHeatCapacitor buffer;

    public ThermodynamicConductor(IBlockProvider blockProvider, TileEntityTransmitter tile) {
        super(tile, TransmissionType.HEAT);
        this.tier = Attribute.getTier(blockProvider.getBlock(), ConductorTier.class);
        this.buffer = BasicHeatCapacitor.create(this.tier.getHeatCapacity(), this.tier.getInverseConduction(), this.tier.getInverseConductionInsulation(), this);
        this.capacitors = Collections.singletonList(this.buffer);
    }

    public AcceptorCache<IHeatHandler> getAcceptorCache() {
        return (AcceptorCache)super.getAcceptorCache();
    }

    @Override
    public ConductorTier getTier() {
        return this.tier;
    }

    @Override
    public HeatNetwork createEmptyNetwork() {
        return new HeatNetwork();
    }

    @Override
    public HeatNetwork createEmptyNetworkWithID(UUID networkID) {
        return new HeatNetwork(networkID);
    }

    @Override
    public HeatNetwork createNetworkByMerging(Collection<HeatNetwork> networks) {
        return new HeatNetwork(networks);
    }

    @Override
    public void takeShare() {
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, Direction side) {
        return ((AcceptorCache)this.getAcceptorCache()).isAcceptorAndListen(tile, side, Capabilities.HEAT_HANDLER_CAPABILITY);
    }

    @Override
    @Nullable
    public ThermodynamicConductorUpgradeData getUpgradeData() {
        return new ThermodynamicConductorUpgradeData(this.redstoneReactive, this.getConnectionTypesRaw(), this.buffer.getHeat());
    }

    @Override
    public boolean dataTypeMatches(@Nonnull TransmitterUpgradeData data) {
        return data instanceof ThermodynamicConductorUpgradeData;
    }

    @Override
    public void parseUpgradeData(@Nonnull ThermodynamicConductorUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.setConnectionTypesRaw(data.connectionTypes);
        this.buffer.setHeat(data.heat);
    }

    @Override
    @Nonnull
    public CompoundNBT write(@Nonnull CompoundNBT tag) {
        tag = super.write(tag);
        tag.func_218657_a("HeatCapacitors", (INBT)DataHandlerUtils.writeContainers(this.getHeatCapacitors(null)));
        return tag;
    }

    @Override
    public void read(@Nonnull CompoundNBT tag) {
        super.read(tag);
        DataHandlerUtils.readContainers(this.getHeatCapacitors(null), tag.func_150295_c("HeatCapacitors", 10));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag(CompoundNBT updateTag) {
        updateTag = super.getReducedUpdateTag(updateTag);
        updateTag.func_74780_a("temperature", this.buffer.getHeat());
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setDoubleIfPresent(tag, "temperature", this.buffer::setHeat);
    }

    public Color getBaseColor() {
        return this.tier.getBaseColor();
    }

    @Override
    @Nonnull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.capacitors;
    }

    @Override
    public void onContentsChanged() {
        if (!this.isRemote() && Math.abs(this.buffer.getTemperature() - this.clientTemperature) > this.buffer.getTemperature() / 20.0) {
            this.clientTemperature = this.buffer.getTemperature();
            this.getTransmitterTile().sendUpdatePacket();
        }
        this.getTransmitterTile().markDirty(false);
    }

    @Override
    @Nullable
    public IHeatHandler getAdjacent(Direction side) {
        if (ThermodynamicConductor.connectionMapContainsSide(this.getAllCurrentConnections(), side)) {
            return ((AcceptorCache)this.getAcceptorCache()).getConnectedAcceptor(side).resolve().orElse(null);
        }
        return null;
    }
}

