/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.distribution;

import javax.annotation.Nonnull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.common.content.network.transmitter.BoxedPressurizedTube;
import mekanism.common.lib.distribution.SplitInfo;
import mekanism.common.lib.distribution.Target;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.util.Direction;

public class BoxedChemicalTransmitterSaveTarget<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends Target<BoxedPressurizedTube, Long, STACK> {
    private STACK currentStored;

    public BoxedChemicalTransmitterSaveTarget(@Nonnull STACK empty, @Nonnull STACK type) {
        this.currentStored = empty;
        this.extra = type;
    }

    @Override
    protected void acceptAmount(BoxedPressurizedTube transmitter, SplitInfo<Long> splitInfo, Long amount) {
        amount = Math.min(amount, transmitter.getCapacity() - ((ChemicalStack)this.currentStored).getAmount());
        ChemicalStack newChemical = ChemicalUtil.copyWithAmount((ChemicalStack)this.extra, amount);
        if (((ChemicalStack)this.currentStored).isEmpty()) {
            this.currentStored = newChemical;
        } else {
            ((ChemicalStack)this.currentStored).grow(amount);
        }
        splitInfo.send(amount);
    }

    @Override
    protected Long simulate(BoxedPressurizedTube transmitter, @Nonnull STACK chemicalStack) {
        if (!((ChemicalStack)this.currentStored).isEmpty() && !((ChemicalStack)this.currentStored).isTypeEqual(chemicalStack)) {
            return 0L;
        }
        return Math.min(((ChemicalStack)chemicalStack).getAmount(), transmitter.getCapacity() - ((ChemicalStack)this.currentStored).getAmount());
    }

    public void saveShare(Direction handlerDirection) {
        BoxedPressurizedTube tube = (BoxedPressurizedTube)this.handlers.get(handlerDirection);
        boolean shouldSave = false;
        if (((ChemicalStack)this.currentStored).isEmpty() != tube.saveShare.isEmpty()) {
            shouldSave = true;
        } else if (!((ChemicalStack)this.currentStored).isEmpty()) {
            ChemicalType chemicalType = ChemicalType.getTypeFor(this.currentStored);
            boolean bl = shouldSave = chemicalType != tube.saveShare.getChemicalType() || !((ChemicalStack)this.currentStored).isStackIdentical(tube.saveShare.getChemicalStack());
        }
        if (shouldSave) {
            tube.saveShare = ((ChemicalStack)this.currentStored).isEmpty() ? BoxedChemicalStack.EMPTY : BoxedChemicalStack.box(this.currentStored);
            tube.getTransmitterTile().markDirty(false);
        }
    }
}

