/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network;

import java.util.Collection;
import java.util.UUID;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatHandler;
import mekanism.common.MekanismLang;
import mekanism.common.content.network.transmitter.ThermodynamicConductor;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.util.text.ITextComponent;

public class HeatNetwork
extends DynamicNetwork<IHeatHandler, HeatNetwork, ThermodynamicConductor> {
    private double meanTemp = 300.0;
    private double heatLost;
    private double heatTransferred;

    public HeatNetwork() {
    }

    public HeatNetwork(UUID networkID) {
        super(networkID);
    }

    public HeatNetwork(Collection<HeatNetwork> networks) {
        this.adoptAllAndRegister(networks);
    }

    @Override
    public ITextComponent getStoredInfo() {
        return MekanismLang.HEAT_NETWORK_STORED.translate(MekanismUtils.getTemperatureDisplay(this.meanTemp, UnitDisplayUtils.TemperatureUnit.KELVIN, true));
    }

    @Override
    public ITextComponent getFlowInfo() {
        ITextComponent transferred = MekanismUtils.getTemperatureDisplay(this.heatTransferred, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
        ITextComponent lost = MekanismUtils.getTemperatureDisplay(this.heatLost, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
        return this.heatTransferred + this.heatLost == 0.0 ? MekanismLang.HEAT_NETWORK_FLOW.translate(transferred, lost) : MekanismLang.HEAT_NETWORK_FLOW_EFFICIENCY.translate(transferred, lost, (float)Math.round(this.heatTransferred / (this.heatTransferred + this.heatLost) * 10000.0) / 100.0f + "%");
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        double newSumTemp = 0.0;
        double newHeatLost = 0.0;
        double newHeatTransferred = 0.0;
        for (ThermodynamicConductor transmitter : this.transmitters) {
            HeatAPI.HeatTransfer transfer = transmitter.simulate();
            transmitter.updateHeatCapacitors(null);
            newHeatTransferred += transfer.getAdjacentTransfer();
            newHeatLost += transfer.getEnvironmentTransfer();
            newSumTemp += transmitter.getTotalTemperature();
        }
        this.heatLost = newHeatLost;
        this.heatTransferred = newHeatTransferred;
        this.meanTemp = newSumTemp / (double)this.transmitters.size();
    }

    public String toString() {
        return "[HeatNetwork] " + this.transmitters.size() + " transmitters, " + this.getAcceptorCount() + " acceptors.";
    }

    @Override
    public ITextComponent getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.HEAT_NETWORK, this.transmitters.size(), this.getAcceptorCount());
    }
}

