/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import java.util.Objects;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.mekatool.ModuleMekaTool;
import mekanism.common.network.PacketLightningRender;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ModuleFarmingUnit
extends ModuleMekaTool {
    private ModuleConfigItem<FarmingRadius> farmingRadius;

    @Override
    public void init() {
        super.init();
        this.farmingRadius = new ModuleConfigItem<FarmingRadius>(this, "farming_radius", MekanismLang.MODULE_FARMING_RADIUS, new ModuleConfigItem.EnumData<FarmingRadius>(FarmingRadius.class, this.getInstalledCount() + 1), FarmingRadius.LOW);
        this.addConfigItem(this.farmingRadius);
    }

    @Override
    public ActionResultType onItemUse(ItemUseContext context) {
        return MekanismUtils.performActions(this.stripLogsAOE(context), () -> this.tillAOE(context, ToolType.SHOVEL, SoundEvents.field_187771_eN, (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShovel.get()), () -> this.tillAOE(context, ToolType.HOE, SoundEvents.field_187693_cj, (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageHoe.get()));
    }

    private ActionResultType tillAOE(ItemUseContext context, ToolType toolType, SoundEvent sound, FloatingLong energyUsage) {
        BlockPos pos;
        PlayerEntity player = context.func_195999_j();
        if (player == null || player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        Direction sideHit = context.func_196000_l();
        if (sideHit == Direction.DOWN) {
            return ActionResultType.PASS;
        }
        int diameter = this.farmingRadius.get().getRadius();
        if (diameter == 0) {
            return ActionResultType.PASS;
        }
        ItemStack stack = context.func_195996_i();
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return ActionResultType.FAIL;
        }
        FloatingLong energy = energyContainer.getEnergy();
        if (energy.smallerThan(energyUsage)) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockState tilledState = world.func_180495_p(pos = context.func_195995_a()).getToolModifiedState(world, pos, player, stack, toolType);
        if (tilledState == null) {
            return ActionResultType.PASS;
        }
        BlockPos abovePos = pos.func_177984_a();
        BlockState aboveState = world.func_180495_p(abovePos);
        if (aboveState.func_200015_d((IBlockReader)world, abovePos)) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        world.func_180501_a(pos, tilledState, 11);
        Material aboveMaterial = aboveState.func_185904_a();
        if (aboveMaterial == Material.field_151585_k || aboveMaterial == Material.field_151582_l) {
            world.func_175655_b(abovePos, true);
        }
        world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        FloatingLong energyUsed = energyUsage.copy();
        int radius = (diameter - 1) / 2;
        for (BlockPos newPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-radius, 0, -radius), (BlockPos)pos.func_177982_a(radius, 0, radius))) {
            if (pos.equals((Object)newPos)) continue;
            if (energyUsed.add(energyUsage).greaterThan(energy)) break;
            BlockState stateAbove = world.func_180495_p(newPos.func_177984_a());
            if (stateAbove.func_200015_d((IBlockReader)world, newPos.func_177984_a()) || tilledState != world.func_180495_p(newPos).getToolModifiedState(world, newPos, player, stack, toolType)) continue;
            newPos = newPos.func_185334_h();
            energyUsed = energyUsed.plusEqual(energyUsage);
            world.func_180501_a(newPos, tilledState, 11);
            aboveMaterial = stateAbove.func_185904_a();
            if (aboveMaterial == Material.field_151585_k || aboveMaterial == Material.field_151582_l) {
                world.func_175655_b(newPos.func_177984_a(), true);
            }
            world.func_184133_a(null, newPos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            Mekanism.packetHandler.sendToAllTracking(new PacketLightningRender(PacketLightningRender.LightningPreset.TOOL_AOE, Objects.hash(pos, newPos), Vector3d.func_237490_a_((Vector3i)pos, (double)0.94), Vector3d.func_237490_a_((Vector3i)newPos, (double)0.94), 10), world, pos);
        }
        energyContainer.extract(energyUsed, Action.EXECUTE, AutomationType.MANUAL);
        return ActionResultType.SUCCESS;
    }

    private ActionResultType stripLogsAOE(ItemUseContext context) {
        BlockPos pos;
        FloatingLong energyUsage;
        PlayerEntity player = context.func_195999_j();
        if (player == null || player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        int diameter = this.farmingRadius.get().getRadius();
        if (diameter == 0) {
            return ActionResultType.PASS;
        }
        ItemStack stack = context.func_195996_i();
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return ActionResultType.FAIL;
        }
        FloatingLong energy = energyContainer.getEnergy();
        if (energy.smallerThan(energyUsage = (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageAxe.get())) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockState clickedState = world.func_180495_p(pos = context.func_195995_a());
        BlockState strippedState = clickedState.getToolModifiedState(world, pos, player, stack, ToolType.AXE);
        if (strippedState == null) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        Direction.Axis axis = (Direction.Axis)clickedState.func_177229_b((Property)RotatedPillarBlock.field_176298_M);
        world.func_180501_a(pos, strippedState, 11);
        world.func_184133_a(null, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
        Direction side = context.func_196000_l();
        FloatingLong energyUsed = energyUsage.copy();
        Vector3d offset = Vector3d.func_237491_b_((Vector3i)side.func_176730_m()).func_186678_a(0.44);
        for (BlockPos newPos : ModuleFarmingUnit.getStrippingArea(pos, side, (diameter - 1) / 2)) {
            if (pos.equals((Object)newPos)) continue;
            if (energyUsed.add(energyUsage).greaterThan(energy)) break;
            BlockState state = world.func_180495_p(newPos);
            if (strippedState != state.getToolModifiedState(world, newPos, player, stack, ToolType.AXE) || axis != state.func_177229_b((Property)RotatedPillarBlock.field_176298_M)) continue;
            newPos = newPos.func_185334_h();
            energyUsed = energyUsed.plusEqual(energyUsage);
            world.func_180501_a(newPos, strippedState, 11);
            world.func_184133_a(null, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            Mekanism.packetHandler.sendToAllTracking(new PacketLightningRender(PacketLightningRender.LightningPreset.TOOL_AOE, Objects.hash(pos, newPos), Vector3d.func_237489_a_((Vector3i)pos).func_178787_e(offset), Vector3d.func_237489_a_((Vector3i)newPos).func_178787_e(offset), 10), world, pos);
        }
        energyContainer.extract(energyUsed, Action.EXECUTE, AutomationType.MANUAL);
        return ActionResultType.SUCCESS;
    }

    private static Iterable<BlockPos> getStrippingArea(BlockPos pos, Direction direction, int radius) {
        AxisAlignedBB box;
        switch (direction) {
            case EAST: 
            case WEST: {
                box = new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() - radius), (double)(pos.func_177952_p() - radius), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + radius), (double)(pos.func_177952_p() + radius));
                break;
            }
            case UP: 
            case DOWN: {
                box = new AxisAlignedBB((double)(pos.func_177958_n() - radius), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - radius), (double)(pos.func_177958_n() + radius), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + radius));
                break;
            }
            case SOUTH: 
            case NORTH: {
                box = new AxisAlignedBB((double)(pos.func_177958_n() - radius), (double)(pos.func_177956_o() - radius), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + radius), (double)(pos.func_177956_o() + radius), (double)pos.func_177952_p());
                break;
            }
            default: {
                return BlockPos.func_218278_a((BlockPos)BlockPos.field_177992_a, (BlockPos)BlockPos.field_177992_a);
            }
        }
        return BlockPos.func_218278_a((BlockPos)new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c), (BlockPos)new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f));
    }

    public static enum FarmingRadius implements IHasTextComponent
    {
        OFF(0),
        LOW(1),
        MED(3),
        HIGH(5),
        ULTRA(7);

        private final int radius;
        private final ITextComponent label;

        private FarmingRadius(int radius) {
            this.radius = radius;
            this.label = new StringTextComponent(Integer.toString(radius));
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.label;
        }

        public int getRadius() {
            return this.radius;
        }
    }
}

