/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.HUDElement;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.Modules;
import mekanism.common.content.gear.mekasuit.ModuleLocomotiveBoostingUnit;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.lib.radiation.capability.IRadiationEntity;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismItems;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class ModuleMekaSuit
extends Module {

    public static class ModuleDosimeterUnit
    extends ModuleMekaSuit {
        private static final ResourceLocation icon = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "dosimeter.png");

        @Override
        public void addHUDElements(List<HUDElement> list) {
            if (!this.isEnabled()) {
                return;
            }
            Optional capability = CapabilityUtils.getCapability((ICapabilityProvider)Minecraft.func_71410_x().field_71439_g, Capabilities.RADIATION_ENTITY_CAPABILITY, null).resolve();
            if (capability.isPresent()) {
                double radiation = ((IRadiationEntity)capability.get()).getRadiation();
                HUDElement e = HUDElement.of(icon, UnitDisplayUtils.getDisplayShort(radiation, UnitDisplayUtils.RadiationUnit.SV, 2));
                HUDElement.HUDColor color = radiation < 1.0E-5 ? HUDElement.HUDColor.REGULAR : (radiation < 0.1 ? HUDElement.HUDColor.WARNING : HUDElement.HUDColor.DANGER);
                list.add(e.color(color));
            }
        }
    }

    public static class ModuleNutritionalInjectionUnit
    extends ModuleMekaSuit {
        private static final ResourceLocation icon = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "nutritional_injection_unit.png");

        @Override
        public void tickServer(PlayerEntity player) {
            ItemMekaSuitArmor item;
            long toFeed;
            super.tickServer(player);
            FloatingLong usage = (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageNutritionalInjection.get();
            if (MekanismUtils.isPlayingMode(player) && player.func_71043_e(false) && this.getContainerEnergy().greaterOrEqual(usage) && (toFeed = Math.min(1L, (item = (ItemMekaSuitArmor)this.getContainer().func_77973_b()).getContainedGas(this.getContainer(), (Gas)MekanismGases.NUTRITIONAL_PASTE.get()).getAmount() / (long)MekanismConfig.general.nutritionalPasteMBPerFood.get())) > 0L) {
                this.useEnergy((LivingEntity)player, usage.multiply(toFeed));
                item.useGas(this.getContainer(), (Gas)MekanismGases.NUTRITIONAL_PASTE.get(), toFeed * (long)MekanismConfig.general.nutritionalPasteMBPerFood.get());
                player.func_71024_bL().func_75122_a(1, MekanismConfig.general.nutritionalPasteSaturation.get());
            }
        }

        @Override
        public void addHUDElements(List<HUDElement> list) {
            if (!this.isEnabled()) {
                return;
            }
            GasStack stored = ((ItemMekaSuitArmor)this.getContainer().func_77973_b()).getContainedGas(this.getContainer(), (Gas)MekanismGases.NUTRITIONAL_PASTE.get());
            double ratio = StorageUtils.getRatio(stored.getAmount(), MekanismConfig.gear.mekaSuitNutritionalMaxStorage.getAsLong());
            list.add(HUDElement.percent(icon, ratio));
        }
    }

    public static class ModuleSolarRechargingUnit
    extends ModuleMekaSuit {
        @Override
        public void tickServer(PlayerEntity player) {
            super.tickServer(player);
            IEnergyContainer energyContainer = this.getEnergyContainer();
            if (energyContainer != null && !energyContainer.getNeeded().isZero() && player.field_70170_p.func_72935_r() && player.field_70170_p.func_226660_f_(new BlockPos(player.func_213303_ch())) && !player.field_70170_p.func_72896_J() && player.field_70170_p.func_230315_m_().func_218272_d()) {
                FloatingLong rate = ((FloatingLong)MekanismConfig.gear.mekaSuitSolarRechargingRate.get()).multiply(this.getInstalledCount());
                energyContainer.insert(rate, Action.EXECUTE, AutomationType.MANUAL);
            }
        }
    }

    public static class ModuleHydraulicPropulsionUnit
    extends ModuleMekaSuit {
        private ModuleConfigItem<JumpBoost> jumpBoost;
        private ModuleConfigItem<StepAssist> stepAssist;

        @Override
        public void init() {
            super.init();
            this.jumpBoost = new ModuleConfigItem<JumpBoost>(this, "jump_boost", MekanismLang.MODULE_JUMP_BOOST, new ModuleConfigItem.EnumData<JumpBoost>(JumpBoost.class, this.getInstalledCount() + 1), JumpBoost.LOW);
            this.addConfigItem(this.jumpBoost);
            this.stepAssist = new ModuleConfigItem<StepAssist>(this, "step_assist", MekanismLang.MODULE_STEP_ASSIST, new ModuleConfigItem.EnumData<StepAssist>(StepAssist.class, this.getInstalledCount() + 1), StepAssist.LOW);
            this.addConfigItem(this.stepAssist);
        }

        public float getBoost() {
            return this.jumpBoost.get().getBoost();
        }

        public float getStepHeight() {
            return this.stepAssist.get().getHeight();
        }

        public static enum StepAssist implements IHasTextComponent
        {
            OFF(0.0f),
            LOW(0.5f),
            MED(1.0f),
            HIGH(1.5f),
            ULTRA(2.0f);

            private final float height;
            private final ITextComponent label;

            private StepAssist(float height) {
                this.height = height;
                this.label = new StringTextComponent(Float.toString(height));
            }

            @Override
            public ITextComponent getTextComponent() {
                return this.label;
            }

            public float getHeight() {
                return this.height;
            }
        }

        public static enum JumpBoost implements IHasTextComponent
        {
            OFF(0.0f),
            LOW(0.5f),
            MED(1.0f),
            HIGH(3.0f),
            ULTRA(5.0f);

            private final float boost;
            private final ITextComponent label;

            private JumpBoost(float boost) {
                this.boost = boost;
                this.label = new StringTextComponent(Float.toString(boost));
            }

            @Override
            public ITextComponent getTextComponent() {
                return this.label;
            }

            public float getBoost() {
                return this.boost;
            }
        }
    }

    public static class ModuleHydraulicAbsorptionUnit
    extends ModuleMekaSuit {
    }

    public static class ModuleGravitationalModulatingUnit
    extends ModuleMekaSuit {
        private static final ResourceLocation icon = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "gravitational_modulation_unit.png");
        private ModuleConfigItem<ModuleLocomotiveBoostingUnit.SprintBoost> speedBoost;

        @Override
        public void init() {
            super.init();
            this.speedBoost = new ModuleConfigItem<ModuleLocomotiveBoostingUnit.SprintBoost>(this, "speed_boost", MekanismLang.MODULE_SPEED_BOOST, new ModuleConfigItem.EnumData<ModuleLocomotiveBoostingUnit.SprintBoost>(ModuleLocomotiveBoostingUnit.SprintBoost.class), ModuleLocomotiveBoostingUnit.SprintBoost.LOW);
            this.addConfigItem(this.speedBoost);
        }

        @Override
        public void addHUDElements(List<HUDElement> list) {
            list.add(HUDElement.enabled(icon, this.isEnabled()));
        }

        @Override
        public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
            this.toggleEnabled(player, (ITextComponent)MekanismLang.MODULE_GRAVITATIONAL_MODULATION.translate(new Object[0]));
        }

        public float getBoost() {
            return this.speedBoost.get().getBoost();
        }
    }

    public static class ModuleRadiationShieldingUnit
    extends ModuleMekaSuit {
    }

    public static class ModuleVisionEnhancementUnit
    extends ModuleMekaSuit {
        private static final ResourceLocation icon = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "vision_enhancement_unit.png");

        @Override
        public void tickServer(PlayerEntity player) {
            super.tickServer(player);
            this.useEnergy((LivingEntity)player, (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageVisionEnhancement.get());
        }

        @Override
        public void addHUDElements(List<HUDElement> list) {
            list.add(HUDElement.enabled(icon, this.isEnabled()));
        }

        @Override
        public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
            this.toggleEnabled(player, (ITextComponent)MekanismLang.MODULE_VISION_ENHANCEMENT.translate(new Object[0]));
        }
    }

    public static class ModuleInhalationPurificationUnit
    extends ModuleMekaSuit {
        private ModuleConfigItem<Boolean> beneficialEffects;
        private ModuleConfigItem<Boolean> neutralEffects;
        private ModuleConfigItem<Boolean> harmfulEffects;

        @Override
        public void init() {
            super.init();
            this.beneficialEffects = new ModuleConfigItem<Boolean>(this, "beneficial_effects", MekanismLang.MODULE_PURIFICATION_BENEFICIAL, new ModuleConfigItem.BooleanData(), false);
            this.addConfigItem(this.beneficialEffects);
            this.neutralEffects = new ModuleConfigItem<Boolean>(this, "neutral_effects", MekanismLang.MODULE_PURIFICATION_NEUTRAL, new ModuleConfigItem.BooleanData(), true);
            this.addConfigItem(this.neutralEffects);
            this.harmfulEffects = new ModuleConfigItem<Boolean>(this, "harmful_effects", MekanismLang.MODULE_PURIFICATION_HARMFUL, new ModuleConfigItem.BooleanData(), true);
            this.addConfigItem(this.harmfulEffects);
        }

        @Override
        public void tickClient(PlayerEntity player) {
            super.tickClient(player);
            if (!player.func_175149_v()) {
                FloatingLong energy;
                FloatingLong usage = (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsagePotionTick.get();
                boolean free = usage.isZero() || player.func_184812_l_();
                FloatingLong floatingLong = energy = free ? FloatingLong.ZERO : this.getContainerEnergy().copy();
                if (free || energy.greaterOrEqual(usage)) {
                    List effects = player.func_70651_bq().stream().filter(effect -> this.canHandle(effect.func_188419_a().func_220303_e())).collect(Collectors.toList());
                    for (EffectInstance effect2 : effects) {
                        if (free) {
                            this.speedupEffect(player, effect2);
                            continue;
                        }
                        energy = energy.minusEqual(usage);
                        this.speedupEffect(player, effect2);
                        if (!energy.smallerThan(usage)) continue;
                        break;
                    }
                }
            }
        }

        @Override
        public void tickServer(PlayerEntity player) {
            IEnergyContainer energyContainer;
            super.tickServer(player);
            FloatingLong usage = (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsagePotionTick.get();
            boolean free = usage.isZero() || player.func_184812_l_();
            IEnergyContainer iEnergyContainer = energyContainer = free ? null : this.getEnergyContainer();
            if (free || energyContainer != null && energyContainer.getEnergy().greaterOrEqual(usage)) {
                List effects = player.func_70651_bq().stream().filter(effect -> this.canHandle(effect.func_188419_a().func_220303_e())).collect(Collectors.toList());
                for (EffectInstance effect2 : effects) {
                    if (free) {
                        this.speedupEffect(player, effect2);
                        continue;
                    }
                    if (this.useEnergy((LivingEntity)player, energyContainer, usage, true).isZero()) break;
                    this.speedupEffect(player, effect2);
                    if (!energyContainer.getEnergy().smallerThan(usage)) continue;
                    break;
                }
            }
        }

        private void speedupEffect(PlayerEntity player, EffectInstance effect) {
            for (int i = 0; i < 9; ++i) {
                effect.func_76455_a((LivingEntity)player, () -> MekanismUtils.onChangedPotionEffect((LivingEntity)player, effect, true));
            }
        }

        private boolean canHandle(EffectType effectType) {
            switch (effectType) {
                case BENEFICIAL: {
                    return this.beneficialEffects.get();
                }
                case HARMFUL: {
                    return this.harmfulEffects.get();
                }
                case NEUTRAL: {
                    return this.neutralEffects.get();
                }
            }
            return false;
        }
    }

    public static class ModuleElectrolyticBreathingUnit
    extends ModuleMekaSuit {
        @Override
        public void tickServer(PlayerEntity player) {
            super.tickServer(player);
            int productionRate = 0;
            double maskHeight = player.func_226280_cw_() - 0.15;
            BlockPos headPos = new BlockPos(player.func_226277_ct_(), maskHeight, player.func_226281_cx_());
            FluidState fluidstate = player.func_130014_f_().func_204610_c(headPos);
            if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && maskHeight <= (double)((float)headPos.func_177956_o() + fluidstate.func_215679_a((IBlockReader)player.func_130014_f_(), headPos))) {
                productionRate = this.getMaxRate();
            } else if (player.func_209511_p()) {
                productionRate = this.getMaxRate() / 2;
            }
            if (productionRate > 0) {
                ItemStack handStack;
                Optional handCapability;
                FloatingLong usage = ((FloatingLong)MekanismConfig.general.FROM_H2.get()).multiply(2L);
                int maxRate = Math.min(productionRate, this.getContainerEnergy().divideToInt(usage));
                long hydrogenUsed = 0L;
                GasStack hydrogenStack = MekanismGases.HYDROGEN.getStack((long)maxRate * 2L);
                ItemStack chestStack = player.func_184582_a(EquipmentSlotType.CHEST);
                Optional chestCapability = chestStack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve();
                if (this.checkChestPlate(chestStack) && chestCapability.isPresent()) {
                    hydrogenUsed = (long)maxRate * 2L - ((IGasHandler)chestCapability.get()).insertChemical(hydrogenStack, Action.EXECUTE).getAmount();
                    hydrogenStack.shrink(hydrogenUsed);
                }
                if ((handCapability = (handStack = player.func_184582_a(EquipmentSlotType.MAINHAND)).getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve()).isPresent()) {
                    hydrogenUsed = (long)maxRate * 2L - ((IGasHandler)handCapability.get()).insertChemical(hydrogenStack, Action.EXECUTE).getAmount();
                }
                int oxygenUsed = Math.min(maxRate, player.func_205010_bg() - player.func_70086_ai());
                long used = Math.max((int)Math.ceil((double)hydrogenUsed / 2.0), oxygenUsed);
                this.useEnergy((LivingEntity)player, usage.multiply(used));
                player.func_70050_g(player.func_70086_ai() + oxygenUsed);
            }
        }

        private boolean checkChestPlate(ItemStack chestPlate) {
            if (chestPlate.func_77973_b() == MekanismItems.MEKASUIT_BODYARMOR.get()) {
                return Modules.load(chestPlate, Modules.JETPACK_UNIT) != null;
            }
            return true;
        }

        private int getMaxRate() {
            return (int)Math.pow(2.0, this.getInstalledCount());
        }
    }
}

