/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.HUDElement;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.Modules;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;

public abstract class Module {
    public static final String ENABLED_KEY = "enabled";
    public static final String HANDLE_MODE_CHANGE_KEY = "handleModeChange";
    protected final List<ModuleConfigItem<?>> configItems = new ArrayList();
    private Modules.ModuleData<?> data;
    private ItemStack container;
    private ModuleConfigItem<Boolean> enabled;
    private ModuleConfigItem<Boolean> handleModeChange;
    private ModuleConfigItem<Boolean> renderHUD;
    private int installed = 1;

    public void init(Modules.ModuleData<?> data, ItemStack container) {
        this.data = data;
        this.container = container;
    }

    public void init() {
        this.enabled = this.addConfigItem(new ModuleConfigItem<Boolean>(this, ENABLED_KEY, MekanismLang.MODULE_ENABLED, new ModuleConfigItem.BooleanData(), !this.data.isDisabledByDefault()));
        if (this.data.handlesModeChange()) {
            this.handleModeChange = this.addConfigItem(new ModuleConfigItem<Boolean>(this, HANDLE_MODE_CHANGE_KEY, MekanismLang.MODULE_HANDLE_MODE_CHANGE, new ModuleConfigItem.BooleanData(), true));
        }
        if (this.data.rendersHUD()) {
            this.renderHUD = this.addConfigItem(new ModuleConfigItem<Boolean>(this, "renderHUD", MekanismLang.MODULE_RENDER_HUD, new ModuleConfigItem.BooleanData(), true));
        }
    }

    protected <T> ModuleConfigItem<T> addConfigItem(ModuleConfigItem<T> item) {
        this.configItems.add(item);
        return item;
    }

    public void tick(PlayerEntity player) {
        if (this.isEnabled()) {
            if (!player.field_70170_p.func_201670_d()) {
                this.tickServer(player);
            } else {
                this.tickClient(player);
            }
        }
    }

    @Nullable
    public IEnergyContainer getEnergyContainer() {
        return StorageUtils.getEnergyContainer(this.getContainer(), 0);
    }

    public FloatingLong getContainerEnergy() {
        IEnergyContainer energyContainer = this.getEnergyContainer();
        return energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
    }

    public boolean canUseEnergy(LivingEntity wearer, FloatingLong energy) {
        IEnergyContainer energyContainer = this.getEnergyContainer();
        if ((!(wearer instanceof PlayerEntity) || MekanismUtils.isPlayingMode((PlayerEntity)wearer)) && energyContainer != null) {
            return energyContainer.extract(energy, Action.SIMULATE, AutomationType.MANUAL).equals(energy);
        }
        return false;
    }

    public FloatingLong useEnergy(LivingEntity wearer, FloatingLong energy) {
        return this.useEnergy(wearer, energy, true);
    }

    public FloatingLong useEnergy(LivingEntity wearer, FloatingLong energy, boolean checkCreative) {
        return this.useEnergy(wearer, this.getEnergyContainer(), energy, checkCreative);
    }

    protected FloatingLong useEnergy(LivingEntity wearer, @Nullable IEnergyContainer energyContainer, FloatingLong energy, boolean checkCreative) {
        if (!(checkCreative && wearer instanceof PlayerEntity && !MekanismUtils.isPlayingMode((PlayerEntity)wearer) || energyContainer == null)) {
            return energyContainer.extract(energy, Action.EXECUTE, AutomationType.MANUAL);
        }
        return FloatingLong.ZERO;
    }

    protected void tickServer(PlayerEntity player) {
    }

    protected void tickClient(PlayerEntity player) {
    }

    public final void read(CompoundNBT nbt) {
        if (nbt.func_150297_b("amount", 3)) {
            this.installed = nbt.func_74762_e("amount");
        }
        this.init();
        for (ModuleConfigItem<?> item : this.configItems) {
            item.read(nbt);
        }
    }

    public final void save(Consumer<ItemStack> callback) {
        CompoundNBT modulesTag = ItemDataUtils.getCompound(this.container, "modules");
        CompoundNBT nbt = modulesTag.func_74775_l(this.data.getName());
        nbt.func_74768_a("amount", this.installed);
        for (ModuleConfigItem<?> item : this.configItems) {
            item.write(nbt);
        }
        modulesTag.func_218657_a(this.data.getName(), (INBT)nbt);
        ItemDataUtils.setCompound(this.container, "modules", modulesTag);
        if (callback != null) {
            callback.accept(this.container);
        }
    }

    public String getName() {
        return this.data.getName();
    }

    public Modules.ModuleData<?> getData() {
        return this.data;
    }

    public int getInstalledCount() {
        return this.installed;
    }

    public void setInstalledCount(int installed) {
        this.installed = installed;
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setDisabledForce() {
        this.enabled.getData().set(false);
        this.save(null);
    }

    protected ItemStack getContainer() {
        return this.container;
    }

    public List<ModuleConfigItem<?>> getConfigItems() {
        return this.configItems;
    }

    public void addHUDStrings(List<ITextComponent> list) {
    }

    public void addHUDElements(List<HUDElement> list) {
    }

    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
    }

    public boolean handlesModeChange() {
        return this.data.handlesModeChange() && this.handleModeChange.get() != false;
    }

    public void setModeHandlingDisabledForce() {
        if (this.data.handlesModeChange()) {
            this.handleModeChange.getData().set(false);
            this.save(null);
        }
    }

    public boolean renderHUD() {
        return this.data.rendersHUD() && this.renderHUD.get() != false;
    }

    public void onAdded(boolean first) {
        for (Module module : Modules.loadAll(this.getContainer())) {
            if (module.getData() == this.getData()) continue;
            if (this.getData().isExclusive() && module.getData().isExclusive()) {
                module.setDisabledForce();
            }
            if (!this.handlesModeChange() || !module.handlesModeChange()) continue;
            module.setModeHandlingDisabledForce();
        }
    }

    public void onRemoved(boolean last) {
    }

    protected void displayModeChange(PlayerEntity player, ITextComponent modeName, IHasTextComponent mode) {
        player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, EnumColor.GRAY, MekanismLang.MODULE_MODE_CHANGE.translate(modeName, EnumColor.INDIGO, mode)), Util.field_240973_b_);
    }

    protected void toggleEnabled(PlayerEntity player, ITextComponent modeName) {
        this.enabled.set(!this.isEnabled(), null);
        MekanismLang lang = this.isEnabled() ? MekanismLang.MODULE_ENABLED_LOWER : MekanismLang.MODULE_DISABLED_LOWER;
        player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, EnumColor.GRAY, MekanismLang.GENERIC_STORED.translate(modeName, this.isEnabled() ? EnumColor.BRIGHT_GREEN : EnumColor.DARK_RED, lang)), Util.field_240973_b_);
    }
}

