/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.blocktype;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.Upgrade;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeSound;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.inventory.container.ContainerProvider;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.SoundEventRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;

public class BlockTypeTile<TILE extends TileEntityMekanism>
extends BlockType {
    private final Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar;

    public BlockTypeTile(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, ILangEntry description) {
        super(description);
        this.tileEntityRegistrar = tileEntityRegistrar;
    }

    public TileEntityType<TILE> getTileType() {
        return this.tileEntityRegistrar.get().getTileEntityType();
    }

    public static class BlockTileBuilder<BLOCK extends BlockTypeTile<TILE>, TILE extends TileEntityMekanism, T extends BlockTileBuilder<BLOCK, TILE, T>>
    extends BlockType.BlockTypeBuilder<BLOCK, T> {
        protected BlockTileBuilder(BLOCK holder) {
            super(holder);
        }

        public static <TILE extends TileEntityMekanism> BlockTileBuilder<BlockTypeTile<TILE>, TILE, ?> createBlock(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, ILangEntry description) {
            return new BlockTileBuilder(new BlockTypeTile<TILE>(tileEntityRegistrar, description));
        }

        public T withSound(SoundEventRegistryObject<SoundEvent> soundRegistrar) {
            return (T)((BlockTileBuilder)this.with(new AttributeSound(soundRegistrar)));
        }

        public T withGui(Supplier<ContainerTypeRegistryObject<? extends MekanismContainer>> containerRegistrar) {
            return (T)((BlockTileBuilder)this.with(new AttributeGui(containerRegistrar)));
        }

        public T withEnergyConfig(FloatingLongSupplier energyUsage, FloatingLongSupplier energyStorage) {
            return (T)((BlockTileBuilder)this.with(new AttributeEnergy(energyUsage, energyStorage)));
        }

        public T withEnergyConfig(FloatingLongSupplier energyStorage) {
            return (T)((BlockTileBuilder)this.with(new AttributeEnergy(null, energyStorage)));
        }

        @SafeVarargs
        public final T with(Attribute.TileAttribute<TILE> ... attrs) {
            ((BlockTypeTile)this.holder).add(attrs);
            return (T)((BlockTileBuilder)this.getThis());
        }

        public T withNamedContainerProvider(Function<TileEntityMekanism, INamedContainerProvider> customContainerSupplier) {
            if (!((BlockTypeTile)this.holder).has(AttributeGui.class)) {
                Mekanism.logger.error("Attempted to set a custom container on a block type without a GUI attribute.");
            }
            ((BlockTypeTile)this.holder).get(AttributeGui.class).setCustomContainer(customContainerSupplier);
            return (T)((BlockTileBuilder)this.getThis());
        }

        public T withCustomContainerProvider(Function<TileEntityMekanism, IContainerProvider> providerFunction) {
            return this.withNamedContainerProvider(tile -> new ContainerProvider((ITextComponent)TextComponentUtil.translate(tile.getBlockType().func_149739_a(), new Object[0]), (IContainerProvider)providerFunction.apply((TileEntityMekanism)tile)));
        }

        public T withEmptyContainer(ContainerTypeRegistryObject<?> container) {
            return this.withCustomContainerProvider(tile -> (i, inv, player) -> new EmptyTileContainer<TileEntityMekanism>(container, i, inv, (TileEntityMekanism)tile));
        }

        public T withSupportedUpgrades(Set<Upgrade> upgrades) {
            ((BlockTypeTile)this.holder).add(new AttributeUpgradeSupport(upgrades));
            return (T)((BlockTileBuilder)this.getThis());
        }
    }
}

