/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import mekanism.api.MekanismAPI;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.command.ChunkCommand;
import mekanism.common.command.ForceRetrogenCommand;
import mekanism.common.command.RadiationCommand;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;

public class CommandMek {
    private static final Map<UUID, Stack<BlockPos>> tpStack = new Object2ObjectOpenHashMap();

    private CommandMek() {
    }

    public static LiteralArgumentBuilder<CommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"mek").then(BuildCommand.COMMAND)).then(ChunkCommand.register())).then(DebugCommand.register())).then(ForceRetrogenCommand.register())).then(RadiationCommand.register())).then(TestRulesCommand.register())).then(TpCommand.register())).then(TppopCommand.register());
    }

    private static class TppopCommand {
        private static final SimpleCommandExceptionType TPOP_EMPTY = new SimpleCommandExceptionType((Message)MekanismLang.COMMAND_ERROR_TPOP_EMPTY.translate(new Object[0]));

        private TppopCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpop").requires(cs -> cs.func_197034_c(2) && cs.func_197022_f() instanceof ServerPlayerEntity)).executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                ServerPlayerEntity player = source.func_197035_h();
                UUID uuid = player.func_110124_au();
                Stack playerLocations = tpStack.getOrDefault(uuid, new Stack());
                if (playerLocations.isEmpty()) {
                    throw TPOP_EMPTY.create();
                }
                BlockPos lastPos = (BlockPos)playerLocations.pop();
                tpStack.put(uuid, playerLocations);
                player.field_71135_a.func_147364_a((double)lastPos.func_177958_n(), (double)lastPos.func_177956_o(), (double)lastPos.func_177952_p(), player.field_70177_z, player.field_70125_A);
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_TPOP.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TppopCommand.getPosition(lastPos), EnumColor.INDIGO, playerLocations.size()), true);
                return 0;
            });
        }

        private static ITextComponent getPosition(BlockPos pos) {
            return MekanismLang.GENERIC_BLOCK_POS.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    private static class TpCommand {
        private TpCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"tp").requires(cs -> cs.func_197034_c(2) && cs.func_197022_f() instanceof ServerPlayerEntity)).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                ServerPlayerEntity player = source.func_197035_h();
                UUID uuid = player.func_110124_au();
                Stack<BlockPos> playerLocations = tpStack.getOrDefault(uuid, new Stack());
                playerLocations.push(player.func_233580_cy_());
                tpStack.put(uuid, playerLocations);
                ILocationArgument location = Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location");
                Vector3d position = location.func_197281_a(source);
                player.field_71135_a.func_147364_a(position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), player.field_70177_z, player.field_70125_A);
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_TP.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TpCommand.getPosition(position)), true);
                return 0;
            }));
        }

        private static ITextComponent getPosition(Vector3d pos) {
            return MekanismLang.GENERIC_BLOCK_POS.translate(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        }
    }

    private static class TestRulesCommand {
        private TestRulesCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"testrules").requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                MinecraftServer server = source.func_197028_i();
                GameRules rules = server.func_200252_aR();
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223600_c)).func_223570_a(true, server);
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223601_d)).func_223570_a(false, server);
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223607_j)).func_223570_a(false, server);
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223617_t)).func_223570_a(false, server);
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223599_b)).func_223570_a(false, server);
                source.func_197023_e().func_241114_a_(2000L);
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_TEST_RULES.translateColored(EnumColor.GRAY, new Object[0]), true);
                return 0;
            });
        }
    }

    private static class DebugCommand {
        private DebugCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"debug").requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
                MekanismAPI.debug = !MekanismAPI.debug;
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)MekanismLang.COMMAND_DEBUG.translateColored(EnumColor.GRAY, BooleanStateDisplay.OnOff.of(MekanismAPI.debug, true)), true);
                return 0;
            });
        }
    }
}

