/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.slot;

import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.holder.slot.ConfigInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHolder;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.util.Direction;

public class InventorySlotHelper {
    private final IInventorySlotHolder slotHolder;
    private boolean built;

    private InventorySlotHelper(IInventorySlotHolder slotHolder) {
        this.slotHolder = slotHolder;
    }

    public static InventorySlotHelper forSide(Supplier<Direction> facingSupplier) {
        return InventorySlotHelper.forSide(facingSupplier, null, null);
    }

    public static InventorySlotHelper forSide(Supplier<Direction> facingSupplier, @Nullable Predicate<RelativeSide> insertPredicate, @Nullable Predicate<RelativeSide> extractPredicate) {
        return new InventorySlotHelper(new InventorySlotHolder(facingSupplier, insertPredicate, extractPredicate));
    }

    public static InventorySlotHelper forSideWithConfig(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        return new InventorySlotHelper(new ConfigInventorySlotHolder(facingSupplier, configSupplier));
    }

    public void addSlot(@Nonnull IInventorySlot slot) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        if (this.slotHolder instanceof InventorySlotHolder) {
            ((InventorySlotHolder)this.slotHolder).addSlot(slot, new RelativeSide[0]);
        } else if (this.slotHolder instanceof ConfigInventorySlotHolder) {
            ((ConfigInventorySlotHolder)this.slotHolder).addSlot(slot);
        } else {
            throw new IllegalArgumentException("Holder does not know how to add slots");
        }
    }

    public void addSlot(@Nonnull IInventorySlot slot, RelativeSide ... sides) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        if (!(this.slotHolder instanceof InventorySlotHolder)) {
            throw new IllegalArgumentException("Holder does not know how to add slots on specific sides");
        }
        ((InventorySlotHolder)this.slotHolder).addSlot(slot, sides);
    }

    public IInventorySlotHolder build() {
        this.built = true;
        return this.slotHolder;
    }
}

