/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import mekanism.common.Mekanism;
import mekanism.common.lib.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;

public class ColorAtlas {
    private static final int ATLAS_SIZE = 16;
    private final String name;
    private final List<ColorRegistryObject> colors = new ArrayList<ColorRegistryObject>();

    public ColorAtlas(String name) {
        this.name = name;
    }

    public ColorRegistryObject register() {
        return this.register(-1);
    }

    public ColorRegistryObject register(int defaultARGB) {
        ColorRegistryObject obj = new ColorRegistryObject(defaultARGB);
        this.colors.add(obj);
        return obj;
    }

    public void parse(ResourceLocation rl) {
        List<Color> parsed = ColorAtlas.load(rl, this.colors.size());
        if (parsed.size() < this.colors.size()) {
            Mekanism.logger.error("Failed to parse '{}' color atlas.", (Object)this.name);
            return;
        }
        for (int i = 0; i < parsed.size(); ++i) {
            this.colors.get(i).setColor(parsed.get(i));
        }
    }

    public static List<Color> load(ResourceLocation rl, int count) {
        ArrayList<Color> ret = new ArrayList<Color>();
        try {
            ColorAtlas.loadColorAtlas(rl, count, ret);
        }
        catch (Exception e) {
            Mekanism.logger.error("Failed to load color atlas: {}", (Object)rl, (Object)e);
            e.printStackTrace();
        }
        return ret;
    }

    private static void loadColorAtlas(ResourceLocation rl, int count, List<Color> ret) throws IOException {
        IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(rl);
        BufferedImage img = ImageIO.read(resource.func_199027_b());
        for (int i = 0; i < count; ++i) {
            int rgb = img.getRGB(i % 16, i / 16);
            if (rgb >> 24 == 0) {
                ret.add(null);
                Mekanism.logger.warn("Unable to retrieve color marker: '{}' for atlas: '{}'. This is likely due to an out of date resource pack.", (Object)count, (Object)rl);
                continue;
            }
            ret.add(Color.argb(rgb));
        }
    }

    public static class ColorRegistryObject
    implements Supplier<Color> {
        private final int defaultARGB;
        private Color color;
        private int argb;

        private ColorRegistryObject(int defaultARGB) {
            this.defaultARGB = defaultARGB;
            this.setColor(null);
        }

        private void setColor(@Nullable Color color) {
            if (color == null) {
                color = Color.argb(this.defaultARGB);
            }
            this.color = color;
            this.argb = color.argb();
        }

        @Override
        public Color get() {
            return this.color;
        }

        public int argb() {
            return this.argb;
        }
    }
}

