/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.particle.LaserParticleData;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class LaserParticle
extends SpriteTexturedParticle {
    private static final IParticleRenderType LASER_TYPE = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder buffer, TextureManager manager) {
            RenderSystem.depthMask((boolean)true);
            manager.func_110577_a(AtlasTexture.field_215262_g);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.alphaFunc((int)516, (float)0.003921569f);
            RenderSystem.disableCull();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        }

        public void func_217599_a(Tessellator tesselator) {
            tesselator.func_78381_a();
        }

        public String toString() {
            return "MEK_LASER_PARTICLE_TYPE";
        }
    };
    private static final float RADIAN_45 = (float)Math.toRadians(45.0);
    private static final float RADIAN_90 = (float)Math.toRadians(90.0);
    private final Direction direction;
    private final float halfLength;

    private LaserParticle(ClientWorld world, Pos3D start, Pos3D end, Direction dir, float energyScale) {
        super(world, (start.field_72450_a + end.field_72450_a) / 2.0, (start.field_72448_b + end.field_72448_b) / 2.0, (start.field_72449_c + end.field_72449_c) / 2.0);
        this.field_70547_e = 5;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 0.0f;
        this.field_70551_j = 0.0f;
        this.field_82339_as = 0.1f;
        this.field_70544_f = energyScale;
        this.halfLength = (float)(end.distance(start) / 2.0);
        this.direction = dir;
        this.updateBoundingBox();
    }

    public void func_225606_a_(@Nonnull IVertexBuilder vertexBuilder, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3d view = renderInfo.func_216785_c();
        float newX = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - view.func_82615_a());
        float newY = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - view.func_82617_b());
        float newZ = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - view.func_82616_c());
        float uMin = this.func_217563_c();
        float uMax = this.func_217564_d();
        float vMin = this.func_217562_e();
        float vMax = this.func_217560_f();
        Quaternion quaternion = this.direction.func_229384_a_();
        quaternion.func_195890_a(Vector3f.field_229181_d_.func_229193_c_(RADIAN_45));
        this.drawComponent(vertexBuilder, this.getResultVector(quaternion, newX, newY, newZ), uMin, uMax, vMin, vMax);
        Quaternion quaternion2 = new Quaternion(quaternion);
        quaternion2.func_195890_a(Vector3f.field_229181_d_.func_229193_c_(RADIAN_90));
        this.drawComponent(vertexBuilder, this.getResultVector(quaternion2, newX, newY, newZ), uMin, uMax, vMin, vMax);
    }

    private Vector3f[] getResultVector(Quaternion quaternion, float newX, float newY, float newZ) {
        Vector3f[] resultVector;
        for (Vector3f vec : resultVector = new Vector3f[]{new Vector3f(-this.field_70544_f, -this.halfLength, 0.0f), new Vector3f(-this.field_70544_f, this.halfLength, 0.0f), new Vector3f(this.field_70544_f, this.halfLength, 0.0f), new Vector3f(this.field_70544_f, -this.halfLength, 0.0f)}) {
            vec.func_214905_a(quaternion);
            vec.func_195904_b(newX, newY, newZ);
        }
        return resultVector;
    }

    private void drawComponent(IVertexBuilder vertexBuilder, Vector3f[] resultVector, float uMin, float uMax, float vMin, float vMax) {
        vertexBuilder.func_225582_a_((double)resultVector[0].func_195899_a(), (double)resultVector[0].func_195900_b(), (double)resultVector[0].func_195902_c()).func_225583_a_(uMax, vMax).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_225587_b_(240, 240).func_181675_d();
        vertexBuilder.func_225582_a_((double)resultVector[1].func_195899_a(), (double)resultVector[1].func_195900_b(), (double)resultVector[1].func_195902_c()).func_225583_a_(uMax, vMin).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_225587_b_(240, 240).func_181675_d();
        vertexBuilder.func_225582_a_((double)resultVector[2].func_195899_a(), (double)resultVector[2].func_195900_b(), (double)resultVector[2].func_195902_c()).func_225583_a_(uMin, vMin).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_225587_b_(240, 240).func_181675_d();
        vertexBuilder.func_225582_a_((double)resultVector[3].func_195899_a(), (double)resultVector[3].func_195900_b(), (double)resultVector[3].func_195902_c()).func_225583_a_(uMin, vMax).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_225587_b_(240, 240).func_181675_d();
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return LASER_TYPE;
    }

    protected void func_187115_a(float particleWidth, float particleHeight) {
        if (particleWidth != this.field_187134_n || particleHeight != this.field_187135_o) {
            this.field_187134_n = particleWidth;
            this.field_187135_o = particleHeight;
        }
    }

    public void func_187109_b(double x, double y, double z) {
        this.field_187126_f = x;
        this.field_187127_g = y;
        this.field_187128_h = z;
        if (this.direction != null) {
            this.updateBoundingBox();
        }
    }

    private void updateBoundingBox() {
        float halfDiameter = this.field_70544_f / 2.0f;
        switch (this.direction) {
            case DOWN: 
            case UP: {
                this.func_187108_a(new AxisAlignedBB(this.field_187126_f - (double)halfDiameter, this.field_187127_g - (double)this.halfLength, this.field_187128_h - (double)halfDiameter, this.field_187126_f + (double)halfDiameter, this.field_187127_g + (double)this.halfLength, this.field_187128_h + (double)halfDiameter));
                break;
            }
            case NORTH: 
            case SOUTH: {
                this.func_187108_a(new AxisAlignedBB(this.field_187126_f - (double)halfDiameter, this.field_187127_g - (double)halfDiameter, this.field_187128_h - (double)this.halfLength, this.field_187126_f + (double)halfDiameter, this.field_187127_g + (double)halfDiameter, this.field_187128_h + (double)this.halfLength));
                break;
            }
            case WEST: 
            case EAST: {
                this.func_187108_a(new AxisAlignedBB(this.field_187126_f - (double)this.halfLength, this.field_187127_g - (double)halfDiameter, this.field_187128_h - (double)halfDiameter, this.field_187126_f + (double)this.halfLength, this.field_187127_g + (double)halfDiameter, this.field_187128_h + (double)halfDiameter));
            }
        }
    }

    public static class Factory
    implements IParticleFactory<LaserParticleData> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public LaserParticle makeParticle(LaserParticleData data, @Nonnull ClientWorld world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Pos3D start = new Pos3D(x, y, z);
            Pos3D end = start.translate(data.direction, data.distance);
            LaserParticle particleLaser = new LaserParticle(world, start, end, data.direction, data.energyScale);
            particleLaser.func_217568_a(this.spriteSet);
            return particleLaser;
        }
    }
}

