/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.Collections;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class ItemStackToChemicalRecipeCategory<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ItemStackToChemicalRecipe<CHEMICAL, STACK>>
extends BaseRecipeCategory<RECIPE> {
    private final IIngredientType<STACK> ingredientType;

    protected ItemStackToChemicalRecipeCategory(IGuiHelper helper, ResourceLocation id, ITextComponent component, IIngredientType<STACK> ingredientType, boolean isConversion) {
        super(helper, id, component, 20, 12, 132, 62);
        this.ingredientType = ingredientType;
        this.guiElements.add(new GuiProgress(isConversion ? () -> 1.0 : () -> (double)this.timer.getValue() / 20.0, ProgressType.LARGE_RIGHT, (IGuiWrapper)this, 64, 40));
    }

    protected abstract GuiChemicalGauge<CHEMICAL, STACK, ?> getGauge(GaugeType var1, int var2, int var3);

    @Override
    protected void addGuiElements() {
        this.guiElements.add(this.getGauge(GaugeType.STANDARD, 133, 13));
        this.guiElements.add(new GuiSlot(SlotType.INPUT, this, 25, 35));
    }

    public void setIngredients(RECIPE recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(((ItemStackToChemicalRecipe)recipe).getInput().getRepresentations()));
        ingredients.setOutput(this.ingredientType, ((ItemStackToChemicalRecipe)recipe).getOutputDefinition());
    }

    public void setRecipe(IRecipeLayout recipeLayout, RECIPE recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 25 - this.xOffset, 35 - this.yOffset);
        itemStacks.set(0, ((ItemStackToChemicalRecipe)recipe).getInput().getRepresentations());
        IGuiIngredientGroup chemicalStacks = recipeLayout.getIngredientsGroup(this.ingredientType);
        this.initChemical(chemicalStacks, 0, false, 134 - this.xOffset, 14 - this.yOffset, 16, 58, Collections.singletonList(((ItemStackToChemicalRecipe)recipe).getOutputDefinition()), true);
    }
}

