/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiEmptyBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;

public class ItemStackGasToItemStackRecipeCategory
extends BaseRecipeCategory<ItemStackGasToItemStackRecipe> {
    public ItemStackGasToItemStackRecipeCategory(IGuiHelper helper, IBlockProvider mekanismBlock) {
        super(helper, mekanismBlock, 28, 16, 144, 54);
    }

    public Class<? extends ItemStackGasToItemStackRecipe> getRecipeClass() {
        return ItemStackGasToItemStackRecipe.class;
    }

    @Override
    protected void addGuiElements() {
        this.guiElements.add(new GuiSlot(SlotType.INPUT, this, 63, 16));
        this.guiElements.add(new GuiSlot(SlotType.POWER, this, 38, 34).with(SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(SlotType.EXTRA, this, 63, 52));
        this.guiElements.add(new GuiSlot(SlotType.OUTPUT, this, 116, 35));
        this.guiElements.add(new GuiVerticalPowerBar((IGuiWrapper)this, () -> 1.0, 164, 15));
        this.guiElements.add(new GuiEmptyBar(this, 68, 36, 6, 12));
        this.guiElements.add(new GuiProgress(() -> (double)this.timer.getValue() / 20.0, ProgressType.BAR, (IGuiWrapper)this, 86, 38));
    }

    public void setIngredients(ItemStackGasToItemStackRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getItemInput().getRepresentations()));
        List<@NonNull TYPE> gasInputs = ((GasStackIngredient)recipe.getChemicalInput()).getRepresentations();
        List scaledGases = gasInputs.stream().map(gas -> new GasStack((GasStack)gas, gas.getAmount() * 200L)).collect(Collectors.toList());
        ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(scaledGases));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getOutputDefinition()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, ItemStackGasToItemStackRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 35, 0);
        itemStacks.init(1, false, 88, 19);
        itemStacks.init(2, false, 35, 36);
        itemStacks.set(0, recipe.getItemInput().getRepresentations());
        itemStacks.set(1, recipe.getOutputDefinition());
        GasStackIngredient gasInput = (GasStackIngredient)recipe.getChemicalInput();
        ArrayList<ItemStack> gasItemProviders = new ArrayList<ItemStack>();
        List<@NonNull TYPE> gasInputs = gasInput.getRepresentations();
        ArrayList<GasStack> scaledGases = new ArrayList<GasStack>();
        for (GasStack gas : gasInputs) {
            gasItemProviders.addAll(MekanismJEI.GAS_STACK_HELPER.getStacksFor(gas.getType(), true));
            scaledGases.add(new GasStack(gas, gas.getAmount() * 200L));
        }
        itemStacks.set(2, gasItemProviders);
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
        this.initChemical(gasStacks, 0, true, 41, 21, 6, 12, scaledGases, false);
    }
}

