/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IItemProvider;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.robit.GuiRobitRepair;
import mekanism.client.jei.CatalystRegistryHelper;
import mekanism.client.jei.ChemicalStackHelper;
import mekanism.client.jei.ChemicalStackRenderer;
import mekanism.client.jei.GhostIngredientHandler;
import mekanism.client.jei.GuiElementHandler;
import mekanism.client.jei.RecipeRegistryHelper;
import mekanism.client.jei.machine.ChemicalCrystallizerRecipeCategory;
import mekanism.client.jei.machine.ChemicalDissolutionRecipeCategory;
import mekanism.client.jei.machine.ChemicalInfuserRecipeCategory;
import mekanism.client.jei.machine.CombinerRecipeCategory;
import mekanism.client.jei.machine.ElectrolysisRecipeCategory;
import mekanism.client.jei.machine.FluidSlurryToSlurryRecipeCategory;
import mekanism.client.jei.machine.FluidToFluidRecipeCategory;
import mekanism.client.jei.machine.GasToGasRecipeCategory;
import mekanism.client.jei.machine.ItemStackGasToItemStackRecipeCategory;
import mekanism.client.jei.machine.ItemStackToEnergyRecipeCategory;
import mekanism.client.jei.machine.ItemStackToGasRecipeCategory;
import mekanism.client.jei.machine.ItemStackToInfuseTypeRecipeCategory;
import mekanism.client.jei.machine.ItemStackToItemStackRecipeCategory;
import mekanism.client.jei.machine.MetallurgicInfuserRecipeCategory;
import mekanism.client.jei.machine.NucleosynthesizingRecipeCategory;
import mekanism.client.jei.machine.PressurizedReactionRecipeCategory;
import mekanism.client.jei.machine.RotaryCondensentratorRecipeCategory;
import mekanism.client.jei.machine.SPSRecipeCategory;
import mekanism.client.jei.machine.SawmillRecipeCategory;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.container.entity.robit.CraftingRobitContainer;
import mekanism.common.inventory.container.tile.FormulaicAssemblicatorContainer;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.IForgeRegistry;

@JeiPlugin
public class MekanismJEI
implements IModPlugin {
    public static final IIngredientType<GasStack> TYPE_GAS = () -> GasStack.class;
    public static final IIngredientType<InfusionStack> TYPE_INFUSION = () -> InfusionStack.class;
    public static final IIngredientType<PigmentStack> TYPE_PIGMENT = () -> PigmentStack.class;
    public static final IIngredientType<SlurryStack> TYPE_SLURRY = () -> SlurryStack.class;
    public static final ChemicalStackHelper.GasStackHelper GAS_STACK_HELPER = new ChemicalStackHelper.GasStackHelper();
    public static final ChemicalStackHelper.InfusionStackHelper INFUSION_STACK_HELPER = new ChemicalStackHelper.InfusionStackHelper();
    public static final ChemicalStackHelper.PigmentStackHelper PIGMENT_STACK_HELPER = new ChemicalStackHelper.PigmentStackHelper();
    public static final ChemicalStackHelper.SlurryStackHelper SLURRY_STACK_HELPER = new ChemicalStackHelper.SlurryStackHelper();
    private static final ResourceLocation ENERGY_CONVERSION = Mekanism.rl("energy_conversion");
    private static final ResourceLocation GAS_CONVERSION = Mekanism.rl("gas_conversion");
    private static final ResourceLocation INFUSION_CONVERSION = Mekanism.rl("infusion_conversion");
    private static final ISubtypeInterpreter MEKANISM_NBT_INTERPRETER = new ISubtypeInterpreter(){

        public String apply(ItemStack stack) {
            if (!stack.func_77942_o()) {
                return "";
            }
            String nbtRepresentation = MekanismJEI.addInterpretation("", MekanismJEI.getChemicalComponent(stack, Capabilities.GAS_HANDLER_CAPABILITY));
            nbtRepresentation = MekanismJEI.addInterpretation(nbtRepresentation, MekanismJEI.getChemicalComponent(stack, Capabilities.INFUSION_HANDLER_CAPABILITY));
            nbtRepresentation = MekanismJEI.addInterpretation(nbtRepresentation, MekanismJEI.getChemicalComponent(stack, Capabilities.PIGMENT_HANDLER_CAPABILITY));
            nbtRepresentation = MekanismJEI.addInterpretation(nbtRepresentation, MekanismJEI.getChemicalComponent(stack, Capabilities.SLURRY_HANDLER_CAPABILITY));
            nbtRepresentation = MekanismJEI.addInterpretation(nbtRepresentation, MekanismJEI.getFluidComponent(stack));
            nbtRepresentation = MekanismJEI.addInterpretation(nbtRepresentation, MekanismJEI.getEnergyComponent(stack));
            return nbtRepresentation;
        }

        public String apply(ItemStack stack, UidContext context) {
            return context == UidContext.Ingredient ? this.apply(stack) : "";
        }
    };

    private static String addInterpretation(String nbtRepresentation, String component) {
        if (nbtRepresentation.isEmpty()) {
            return component;
        }
        return nbtRepresentation + ":" + component;
    }

    private static String getChemicalComponent(ItemStack stack, Capability<? extends IChemicalHandler<?, ?>> capability) {
        Optional cap = stack.getCapability(capability).resolve();
        if (cap.isPresent()) {
            IChemicalHandler handler = (IChemicalHandler)cap.get();
            String component = "";
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                Object chemicalStack = handler.getChemicalInTank(tank);
                if (!((ChemicalStack)chemicalStack).isEmpty()) {
                    component = MekanismJEI.addInterpretation(component, ((ChemicalStack)chemicalStack).getTypeRegistryName().toString());
                    continue;
                }
                if (tanks <= 1) continue;
                component = MekanismJEI.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    private static String getFluidComponent(ItemStack stack) {
        Optional cap = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (cap.isPresent()) {
            IFluidHandlerItem handler = (IFluidHandlerItem)cap.get();
            String component = "";
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                FluidStack fluidStack = handler.getFluidInTank(tank);
                if (!fluidStack.isEmpty()) {
                    component = MekanismJEI.addInterpretation(component, fluidStack.getFluid().getRegistryName().toString());
                    continue;
                }
                if (tanks <= 1) continue;
                component = MekanismJEI.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    private static String getEnergyComponent(ItemStack stack) {
        Optional capability = stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY).resolve();
        if (capability.isPresent()) {
            IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)capability.get();
            String component = "";
            int containers = energyHandlerItem.getEnergyContainerCount();
            for (int container = 0; container < containers; ++container) {
                FloatingLong neededEnergy = energyHandlerItem.getNeededEnergy(container);
                if (neededEnergy.isZero()) {
                    component = MekanismJEI.addInterpretation(component, "filled");
                    continue;
                }
                if (containers <= 1) continue;
                component = MekanismJEI.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return Mekanism.rl("jei_plugin");
    }

    public static void registerItemSubtypes(ISubtypeRegistration registry, List<? extends IItemProvider> itemProviders) {
        for (IItemProvider iItemProvider : itemProviders) {
            ItemStack itemStack = iItemProvider.getItemStack();
            if (!itemStack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY).isPresent() && !itemStack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent() && !itemStack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).isPresent() && !itemStack.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY).isPresent() && !itemStack.getCapability(Capabilities.SLURRY_HANDLER_CAPABILITY).isPresent() && !FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent()) continue;
            registry.registerSubtypeInterpreter(iItemProvider.getItem(), MEKANISM_NBT_INTERPRETER);
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        MekanismJEI.registerItemSubtypes(registry, MekanismItems.ITEMS.getAllItems());
        MekanismJEI.registerItemSubtypes(registry, MekanismBlocks.BLOCKS.getAllBlocks());
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        this.registerIngredientType(registry, MekanismAPI.gasRegistry(), TYPE_GAS, GAS_STACK_HELPER, GasStack::new);
        this.registerIngredientType(registry, MekanismAPI.infuseTypeRegistry(), TYPE_INFUSION, INFUSION_STACK_HELPER, InfusionStack::new);
        this.registerIngredientType(registry, MekanismAPI.pigmentRegistry(), TYPE_PIGMENT, PIGMENT_STACK_HELPER, PigmentStack::new);
        this.registerIngredientType(registry, MekanismAPI.slurryRegistry(), TYPE_SLURRY, SLURRY_STACK_HELPER, SlurryStack::new);
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void registerIngredientType(IModIngredientRegistration registry, IForgeRegistry<CHEMICAL> forgeRegistry, IIngredientType<STACK> ingredientType, ChemicalStackHelper<CHEMICAL, STACK> stackHelper, ChemicalUtils.ChemicalToStackCreator<CHEMICAL, STACK> stackCreator) {
        List types = forgeRegistry.getValues().stream().filter(chemical -> !chemical.isEmptyType() && !chemical.isHidden()).map(chemical -> stackCreator.createStack(chemical, 1000L)).collect(Collectors.toList());
        registry.register(ingredientType, types, stackHelper, new ChemicalStackRenderer());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalCrystallizerRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalDissolutionRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalInfuserRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidSlurryToSlurryRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ElectrolysisRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MetallurgicInfuserRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PressurizedReactionRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RotaryCondensentratorRecipeCategory(guiHelper, true)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RotaryCondensentratorRecipeCategory(guiHelper, false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToGasRecipeCategory(guiHelper, MekanismBlocks.CHEMICAL_OXIDIZER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToGasRecipeCategory(guiHelper, MekanismBlocks.NUTRITIONAL_LIQUIFIER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GasToGasRecipeCategory(guiHelper, MekanismBlocks.SOLAR_NEUTRON_ACTIVATOR)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GasToGasRecipeCategory(guiHelper, MekanismBlocks.ISOTOPIC_CENTRIFUGE)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CombinerRecipeCategory(guiHelper, MekanismBlocks.COMBINER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackGasToItemStackRecipeCategory(guiHelper, MekanismBlocks.PURIFICATION_CHAMBER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackGasToItemStackRecipeCategory(guiHelper, MekanismBlocks.OSMIUM_COMPRESSOR)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackGasToItemStackRecipeCategory(guiHelper, MekanismBlocks.CHEMICAL_INJECTION_CHAMBER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new NucleosynthesizingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SPSRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SawmillRecipeCategory(guiHelper, MekanismBlocks.PRECISION_SAWMILL)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToItemStackRecipeCategory(guiHelper, MekanismBlocks.ENRICHMENT_CHAMBER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToItemStackRecipeCategory(guiHelper, MekanismBlocks.CRUSHER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToItemStackRecipeCategory(guiHelper, MekanismBlocks.ENERGIZED_SMELTER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidToFluidRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToEnergyRecipeCategory(guiHelper, ENERGY_CONVERSION)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToGasRecipeCategory(guiHelper, GAS_CONVERSION)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToInfuseTypeRecipeCategory(guiHelper, INFUSION_CONVERSION)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(GuiRobitRepair.class, 102, 48, 22, 15, new ResourceLocation[]{VanillaRecipeCategoryUid.ANVIL});
        registry.addGenericGuiContainerHandler(GuiMekanism.class, (IGuiContainerHandler)new GuiElementHandler());
        registry.addGhostIngredientHandler(GuiMekanism.class, new GhostIngredientHandler());
    }

    public void registerRecipes(IRecipeRegistration registry) {
        RecipeRegistryHelper.register(registry, MekanismBlocks.ENERGIZED_SMELTER, MekanismRecipeType.SMELTING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.ENRICHMENT_CHAMBER, MekanismRecipeType.ENRICHING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.CRUSHER, MekanismRecipeType.CRUSHING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.COMBINER, MekanismRecipeType.COMBINING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.PURIFICATION_CHAMBER, MekanismRecipeType.PURIFYING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.OSMIUM_COMPRESSOR, MekanismRecipeType.COMPRESSING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_INJECTION_CHAMBER, MekanismRecipeType.INJECTING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.PRECISION_SAWMILL, MekanismRecipeType.SAWING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.METALLURGIC_INFUSER, MekanismRecipeType.METALLURGIC_INFUSING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_CRYSTALLIZER, MekanismRecipeType.CRYSTALLIZING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER, MekanismRecipeType.DISSOLUTION);
        RecipeRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_INFUSER, MekanismRecipeType.CHEMICAL_INFUSING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_OXIDIZER, MekanismRecipeType.OXIDIZING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_WASHER, MekanismRecipeType.WASHING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.SOLAR_NEUTRON_ACTIVATOR, MekanismRecipeType.ACTIVATING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.ISOTOPIC_CENTRIFUGE, MekanismRecipeType.CENTRIFUGING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.ELECTROLYTIC_SEPARATOR, MekanismRecipeType.SEPARATING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER, MekanismRecipeType.EVAPORATING);
        RecipeRegistryHelper.register(registry, MekanismBlocks.PRESSURIZED_REACTION_CHAMBER, MekanismRecipeType.REACTION);
        RecipeRegistryHelper.register(registry, MekanismBlocks.ANTIPROTONIC_NUCLEOSYNTHESIZER, MekanismRecipeType.NUCLEOSYNTHESIZING);
        RecipeRegistryHelper.registerCondensentrator(registry);
        RecipeRegistryHelper.registerNutritionalLiquifier(registry);
        RecipeRegistryHelper.registerSPS(registry);
        RecipeRegistryHelper.register(registry, ENERGY_CONVERSION, MekanismRecipeType.ENERGY_CONVERSION);
        RecipeRegistryHelper.register(registry, GAS_CONVERSION, MekanismRecipeType.GAS_CONVERSION);
        RecipeRegistryHelper.register(registry, INFUSION_CONVERSION, MekanismRecipeType.INFUSION_CONVERSION);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        CatalystRegistryHelper.register(registry, MekanismBlocks.ENRICHMENT_CHAMBER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CRUSHER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.COMBINER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.PURIFICATION_CHAMBER, GAS_CONVERSION);
        CatalystRegistryHelper.register(registry, MekanismBlocks.OSMIUM_COMPRESSOR, GAS_CONVERSION);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_INJECTION_CHAMBER, GAS_CONVERSION);
        CatalystRegistryHelper.register(registry, MekanismBlocks.PRECISION_SAWMILL, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.METALLURGIC_INFUSER, INFUSION_CONVERSION);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_CRYSTALLIZER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER, GAS_CONVERSION);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_INFUSER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_OXIDIZER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.CHEMICAL_WASHER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.SOLAR_NEUTRON_ACTIVATOR, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.ELECTROLYTIC_SEPARATOR, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.PRESSURIZED_REACTION_CHAMBER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.ISOTOPIC_CENTRIFUGE, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.NUTRITIONAL_LIQUIFIER, new ResourceLocation[0]);
        CatalystRegistryHelper.register(registry, MekanismBlocks.ANTIPROTONIC_NUCLEOSYNTHESIZER, GAS_CONVERSION);
        CatalystRegistryHelper.registerCondensentrator(registry);
        CatalystRegistryHelper.register(registry, MekanismBlocks.ENERGIZED_SMELTER, VanillaRecipeCategoryUid.FURNACE);
        CatalystRegistryHelper.registerRecipeItem(registry, MekanismBlocks.FORMULAIC_ASSEMBLICATOR, VanillaRecipeCategoryUid.CRAFTING);
        CatalystRegistryHelper.registerRecipeItem(registry, MekanismItems.ROBIT, MekanismBlocks.ENERGIZED_SMELTER.getRegistryName(), VanillaRecipeCategoryUid.ANVIL, VanillaRecipeCategoryUid.CRAFTING, VanillaRecipeCategoryUid.FURNACE);
        registry.addRecipeCatalyst((Object)MekanismBlocks.BASIC_ENERGY_CUBE.getItemStack(), new ResourceLocation[]{ENERGY_CONVERSION});
        registry.addRecipeCatalyst((Object)MekanismBlocks.ADVANCED_ENERGY_CUBE.getItemStack(), new ResourceLocation[]{ENERGY_CONVERSION});
        registry.addRecipeCatalyst((Object)MekanismBlocks.ELITE_ENERGY_CUBE.getItemStack(), new ResourceLocation[]{ENERGY_CONVERSION});
        registry.addRecipeCatalyst((Object)MekanismBlocks.ULTIMATE_ENERGY_CUBE.getItemStack(), new ResourceLocation[]{ENERGY_CONVERSION});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(CraftingRobitContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(FormulaicAssemblicatorContainer.class, VanillaRecipeCategoryUid.CRAFTING, 19, 9, 35, 36);
    }
}

