/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiFilterHolder;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.filter.miner.GuiMinerFilerSelect;
import mekanism.client.gui.element.filter.miner.GuiMinerItemStackFilter;
import mekanism.client.gui.element.filter.miner.GuiMinerMaterialFilter;
import mekanism.client.gui.element.filter.miner.GuiMinerModIDFilter;
import mekanism.client.gui.element.filter.miner.GuiMinerTagFilter;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.text.InputValidator;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.MinerItemStackFilter;
import mekanism.common.content.miner.MinerMaterialFilter;
import mekanism.common.content.miner.MinerModIDFilter;
import mekanism.common.content.miner.MinerTagFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class GuiDigitalMinerConfig
extends GuiFilterHolder<MinerFilter<?>, TileEntityDigitalMiner, MekanismTileContainer<TileEntityDigitalMiner>> {
    private GuiTextField radiusField;
    private GuiTextField minField;
    private GuiTextField maxField;

    public GuiDigitalMinerConfig(MekanismTileContainer<TileEntityDigitalMiner> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new TranslationButton(this, this.field_147003_i + 56, this.field_147009_r + 136, 96, 20, MekanismLang.BUTTON_NEW_FILTER, () -> this.addWindow(new GuiMinerFilerSelect(this, (TileEntityDigitalMiner)this.tile))));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, this.field_147003_i + 5, this.field_147009_r + 5, 11, 14, this.getButtonLocation("back"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON, this.tile))));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, this.field_147003_i + 11, this.field_147009_r + 141, 14, this.getButtonLocation("strict_input"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.INVERSE_BUTTON, this.tile)), this.getOnHover(MekanismLang.MINER_INVERSE)));
        this.radiusField = new GuiTextField(this, 13, 67, 38, 11);
        this.func_230480_a_(this.radiusField);
        this.radiusField.setMaxStringLength(Integer.toString(MekanismConfig.general.minerMaxRadius.get()).length());
        this.radiusField.setInputValidator(InputValidator.DIGIT);
        this.radiusField.configureDigitalBorderInput(this::setRadius);
        this.minField = new GuiTextField(this, 13, 92, 38, 11);
        this.func_230480_a_(this.minField);
        this.minField.setMaxStringLength(3);
        this.minField.setInputValidator(InputValidator.DIGIT);
        this.minField.configureDigitalBorderInput(this::setMinY);
        this.maxField = new GuiTextField(this, 13, 117, 38, 11);
        this.func_230480_a_(this.maxField);
        this.maxField.setMaxStringLength(3);
        this.maxField.setInputValidator(InputValidator.DIGIT);
        this.maxField.configureDigitalBorderInput(this::setMaxY);
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.drawForegroundText(matrix, mouseX, mouseY);
        this.drawTitleText(matrix, (ITextComponent)MekanismLang.MINER_CONFIG.translate(new Object[0]), this.field_238743_q_);
        this.drawTextWithScale(matrix, (ITextComponent)MekanismLang.FILTERS.translate(new Object[0]), 14.0f, 22.0f, this.screenTextColor(), 0.8f);
        this.drawTextWithScale(matrix, (ITextComponent)MekanismLang.FILTER_COUNT.translate(this.getFilters().size()), 14.0f, 31.0f, this.screenTextColor(), 0.8f);
        this.drawTextWithScale(matrix, (ITextComponent)MekanismLang.MINER_IS_INVERSE.translate(BooleanStateDisplay.OnOff.of(((TileEntityDigitalMiner)this.tile).inverse)), 14.0f, 131.0f, this.screenTextColor(), 0.8f);
        this.drawTextWithScale(matrix, (ITextComponent)MekanismLang.MINER_RADIUS.translate(((TileEntityDigitalMiner)this.tile).getRadius()), 14.0f, 58.0f, this.screenTextColor(), 0.8f);
        this.drawTextWithScale(matrix, (ITextComponent)MekanismLang.MIN.translate(((TileEntityDigitalMiner)this.tile).getMinY()), 14.0f, 83.0f, this.screenTextColor(), 0.8f);
        this.drawTextWithScale(matrix, (ITextComponent)MekanismLang.MAX.translate(((TileEntityDigitalMiner)this.tile).getMaxY()), 14.0f, 108.0f, this.screenTextColor(), 0.8f);
    }

    @Override
    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof IItemStackFilter) {
            this.addWindow(GuiMinerItemStackFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerItemStackFilter)filter));
        } else if (filter instanceof ITagFilter) {
            this.addWindow(GuiMinerTagFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerTagFilter)filter));
        } else if (filter instanceof IMaterialFilter) {
            this.addWindow(GuiMinerMaterialFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerMaterialFilter)filter));
        } else if (filter instanceof IModIDFilter) {
            this.addWindow(GuiMinerModIDFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerModIDFilter)filter));
        }
    }

    private void setRadius() {
        if (!this.radiusField.getText().isEmpty()) {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SET_RADIUS, (TileEntity)this.tile, Integer.parseInt(this.radiusField.getText())));
            this.radiusField.setText("");
        }
    }

    private void setMinY() {
        if (!this.minField.getText().isEmpty()) {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SET_MIN_Y, (TileEntity)this.tile, Integer.parseInt(this.minField.getText())));
            this.minField.setText("");
        }
    }

    private void setMaxY() {
        if (!this.maxField.getText().isEmpty()) {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SET_MAX_Y, (TileEntity)this.tile, Integer.parseInt(this.maxField.getText())));
            this.maxField.setText("");
        }
    }

    @Override
    protected List<ItemStack> getTagStacks(String tagName) {
        return TagCache.getBlockTagStacks(tagName);
    }
}

