/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.network.PacketSecurityMode;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;

public class GuiSecurityTab
extends GuiInsetElement<ISecurityObject> {
    private static final ResourceLocation PUBLIC = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "public.png");
    private static final ResourceLocation PRIVATE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "private.png");
    private static final ResourceLocation PROTECTED = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "protected.png");
    @Nullable
    private final Hand currentHand;

    public GuiSecurityTab(IGuiWrapper gui, ISecurityObject securityObject) {
        this(gui, securityObject, 34);
    }

    public GuiSecurityTab(IGuiWrapper gui, ISecurityObject securityObject, int y) {
        super(PUBLIC, gui, securityObject, gui.getWidth(), y, 26, 18, false);
        this.currentHand = null;
    }

    private static ISecurityObject getItemSecurityObject(@Nonnull Hand hand) {
        return SecurityUtils.wrapSecurityItem(() -> {
            ItemStack stack = GuiSecurityTab.minecraft.field_71439_g.func_184586_b(hand);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISecurityItem)) {
                GuiSecurityTab.minecraft.field_71439_g.func_71053_j();
                return ItemStack.field_190927_a;
            }
            return stack;
        });
    }

    public GuiSecurityTab(IGuiWrapper gui, @Nonnull Hand hand) {
        super(PUBLIC, gui, GuiSecurityTab.getItemSecurityObject(hand), gui.getWidth(), 34, 26, 18, false);
        this.currentHand = hand;
    }

    @Override
    protected void colorTab() {
        MekanismRenderer.color(SpecialColors.TAB_SECURITY);
    }

    @Override
    protected ResourceLocation getOverlay() {
        SecurityData data;
        SecurityMode mode = this.getSecurity();
        UUID ownerUUID = ((ISecurityObject)this.dataSource).getOwnerUUID();
        SecurityData securityData = data = ownerUUID == null ? null : MekanismClient.clientSecurityMap.get(ownerUUID);
        if (data != null && data.override) {
            mode = data.mode;
        }
        if (mode == SecurityMode.PRIVATE) {
            return PRIVATE;
        }
        if (mode == SecurityMode.TRUSTED) {
            return PROTECTED;
        }
        return super.getOverlay();
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        IFormattableTextComponent securityComponent = MekanismLang.SECURITY.translateColored(EnumColor.GRAY, SecurityUtils.getSecurity((ISecurityObject)this.dataSource, Dist.CLIENT));
        ITextComponent ownerComponent = OwnerDisplay.of((PlayerEntity)GuiSecurityTab.minecraft.field_71439_g, ((ISecurityObject)this.dataSource).getOwnerUUID(), ((ISecurityObject)this.dataSource).getOwnerName()).getTextComponent();
        if (SecurityUtils.isOverridden((ISecurityObject)this.dataSource, Dist.CLIENT)) {
            this.displayTooltips(matrix, Arrays.asList(securityComponent, ownerComponent, MekanismLang.SECURITY_OVERRIDDEN.translateColored(EnumColor.RED, new Object[0])), mouseX, mouseY);
        } else {
            this.displayTooltips(matrix, Arrays.asList(securityComponent, ownerComponent), mouseX, mouseY);
        }
    }

    private SecurityMode getSecurity() {
        return MekanismConfig.general.allowProtection.get() ? ((ISecurityObject)this.dataSource).getSecurityMode() : SecurityMode.PUBLIC;
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        UUID owner;
        if (MekanismConfig.general.allowProtection.get() && (owner = ((ISecurityObject)this.dataSource).getOwnerUUID()) != null && GuiSecurityTab.minecraft.field_71439_g.func_110124_au().equals(owner)) {
            if (this.currentHand != null) {
                Mekanism.packetHandler.sendToServer(new PacketSecurityMode(this.currentHand, (SecurityMode)this.getSecurity().getNext()));
            } else if (this.dataSource instanceof TileEntity) {
                Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.NEXT_SECURITY_MODE, (TileEntity)this.dataSource));
            } else if (this.dataSource instanceof Entity) {
                Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionEntity.NEXT_SECURITY_MODE, ((Entity)this.dataSource).func_145782_y()));
            }
        }
    }
}

