/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import net.minecraft.util.ResourceLocation;

public abstract class GuiScrollableElement
extends GuiTexturedElement {
    protected double scroll;
    private boolean isDragging;
    private int dragOffset;
    protected final int barXShift;
    protected final int barX;
    protected final int barY;
    protected final int barWidth;
    protected final int barHeight;
    protected final int maxBarHeight;

    protected GuiScrollableElement(ResourceLocation resource, IGuiWrapper gui, int x, int y, int width, int height, int barXShift, int barYShift, int barWidth, int barHeight, int maxBarHeight) {
        super(resource, gui, x, y, width, height);
        this.barXShift = barXShift;
        this.barX = this.field_230690_l_ + barXShift;
        this.barY = this.field_230691_m_ + barYShift;
        this.barWidth = barWidth;
        this.barHeight = barHeight;
        this.maxBarHeight = maxBarHeight;
    }

    protected abstract int getMaxElements();

    protected abstract int getFocusedElements();

    public void func_230982_a_(double mouseX, double mouseY) {
        super.func_230982_a_(mouseX, mouseY);
        int scroll = this.getScroll();
        if (mouseX >= (double)this.barX && mouseX <= (double)(this.barX + this.barWidth) && mouseY >= (double)(this.barY + scroll) && mouseY <= (double)(this.barY + scroll + this.barHeight)) {
            if (this.needsScrollBars()) {
                double yAxis = mouseY - (double)this.guiObj.getTop();
                this.dragOffset = (int)(yAxis - (double)(scroll + this.barY));
                this.isDragging = true;
            } else {
                this.scroll = 0.0;
            }
        }
    }

    @Override
    public void func_230983_a_(double mouseX, double mouseY, double mouseXOld, double mouseYOld) {
        super.func_230983_a_(mouseX, mouseY, mouseXOld, mouseYOld);
        if (this.needsScrollBars() && this.isDragging) {
            double yAxis = mouseY - (double)this.guiObj.getTop();
            this.scroll = Math.min(Math.max((yAxis - (double)this.barY - (double)this.dragOffset) / (double)this.getMax(), 0.0), 1.0);
        }
    }

    @Override
    public void func_231000_a__(double mouseX, double mouseY) {
        super.func_231000_a__(mouseX, mouseY);
        this.dragOffset = 0;
        this.isDragging = false;
    }

    protected boolean needsScrollBars() {
        return this.getMaxElements() > this.getFocusedElements();
    }

    private int getMax() {
        return this.maxBarHeight - this.barHeight;
    }

    protected int getScroll() {
        int max = this.getMax();
        return Math.max(Math.min((int)(this.scroll * (double)max), max), 0);
    }

    public int getCurrentSelection() {
        if (this.needsScrollBars()) {
            int size = this.getMaxElements() - this.getFocusedElements();
            return (int)(((double)size + 0.5) * this.scroll);
        }
        return 0;
    }

    public boolean adjustScroll(double delta) {
        int elements;
        if (delta != 0.0 && this.needsScrollBars() && (elements = this.getMaxElements() - this.getFocusedElements()) > 0) {
            delta = delta > 0.0 ? 1.0 : -1.0;
            this.scroll = (float)(this.scroll - delta / (double)elements);
            if (this.scroll < 0.0) {
                this.scroll = 0.0;
            } else if (this.scroll > 1.0) {
                this.scroll = 1.0;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPersistentData() {
        return true;
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiScrollableElement old = (GuiScrollableElement)element;
        if (this.needsScrollBars() && old.needsScrollBars()) {
            this.scroll = old.scroll;
        }
    }
}

