/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.filter.transporter;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.filter.GuiFilterHelper;
import mekanism.client.gui.element.filter.GuiFilterSelect;
import mekanism.client.gui.element.filter.transporter.GuiSorterFilerSelect;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;

public interface GuiSorterFilterHelper
extends GuiFilterHelper<TileEntityLogisticalSorter>,
IFancyFontRenderer {
    default public void addSorterDefaults(IGuiWrapper gui, SorterFilter<?> filter, int slotOffset, Consumer<GuiElement> childAdder) {
        int slotX = this.getRelativeX() + 7;
        int colorSlotY = this.getRelativeY() + slotOffset + 25;
        childAdder.accept(new GuiSlot(SlotType.NORMAL, gui, slotX, colorSlotY));
        childAdder.accept(new ColorButton(gui, gui.getLeft() + slotX + 1, gui.getTop() + colorSlotY + 1, 16, 16, () -> filter.color, () -> {
            filter.color = Screen.func_231173_s_() ? null : TransporterUtils.increment(filter.color);
        }, () -> {
            filter.color = TransporterUtils.decrement(filter.color);
        }));
        childAdder.accept(new MekanismImageButton(gui, gui.getLeft() + this.getRelativeX() + 148, gui.getTop() + this.getRelativeY() + 19, 11, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "default.png"), () -> {
            filter.allowDefault = !filter.allowDefault;
        }, (onHover, matrix, xAxis, yAxis) -> gui.displayTooltip(matrix, (ITextComponent)MekanismLang.FILTER_ALLOW_DEFAULT.translate(new Object[0]), xAxis, yAxis)));
    }

    @Override
    default public GuiFilterSelect getFilterSelect(IGuiWrapper gui, TileEntityLogisticalSorter tile) {
        return new GuiSorterFilerSelect(gui, tile);
    }

    default public void renderSorterForeground(MatrixStack matrix, SorterFilter<?> filter) {
        this.drawString(matrix, BooleanStateDisplay.OnOff.of(filter.allowDefault).getTextComponent(), this.getRelativeX() + 161, this.getRelativeY() + 21, this.titleTextColor());
    }
}

