/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.FilterSelectButton;
import mekanism.client.gui.element.slot.GuiSequencedSlotDisplay;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.lib.HashList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.NonNullSupplier;

public class MovableFilterButton
extends FilterButton {
    private final FilterSelectButton upButton;
    private final FilterSelectButton downButton;
    private final GuiSequencedSlotDisplay slotDisplay;
    private IFilter<?> prevFilter;

    public MovableFilterButton(IGuiWrapper gui, int x, int y, int index, IntSupplier filterIndex, Supplier<HashList<? extends IFilter<?>>> filters, IntConsumer upButtonPress, IntConsumer downButtonPress, ObjIntConsumer<IFilter<?>> onPress, Function<IFilter<?>, List<ItemStack>> renderStackSupplier) {
        this(gui, x, y, 96, 29, index, filterIndex, filters, upButtonPress, downButtonPress, onPress, renderStackSupplier);
    }

    public MovableFilterButton(IGuiWrapper gui, int x, int y, int width, int height, int index, IntSupplier filterIndex, Supplier<HashList<? extends IFilter<?>>> filters, IntConsumer upButtonPress, IntConsumer downButtonPress, ObjIntConsumer<IFilter<?>> onPress, Function<IFilter<?>, List<ItemStack>> renderStackSupplier) {
        super(gui, x, y, width, height, index, filterIndex, filters, onPress);
        int arrowX = this.field_230690_l_ + width - 12;
        this.upButton = new FilterSelectButton(gui, arrowX, this.field_230691_m_ + 1, false, () -> upButtonPress.accept(index + filterIndex.getAsInt()), (onHover, matrix, xAxis, yAxis) -> this.displayTooltip(matrix, (ITextComponent)MekanismLang.MOVE_UP.translate(new Object[0]), xAxis, yAxis));
        this.downButton = new FilterSelectButton(gui, arrowX, this.field_230691_m_ + height - 8, true, () -> downButtonPress.accept(index + filterIndex.getAsInt()), (onHover, matrix, xAxis, yAxis) -> this.displayTooltip(matrix, (ITextComponent)MekanismLang.MOVE_DOWN.translate(new Object[0]), xAxis, yAxis));
        this.slotDisplay = new GuiSequencedSlotDisplay(gui, x + 3, y + 3, (NonNullSupplier<List<ItemStack>>)((NonNullSupplier)() -> (List)renderStackSupplier.apply((IFilter<?>)((HashList)filters.get()).getOrNull(filterIndex.getAsInt() + index))));
        this.addChild(this.slotDisplay);
    }

    @Override
    public void func_230982_a_(double mouseX, double mouseY) {
        if (this.upButton.func_231047_b_(mouseX, mouseY)) {
            this.upButton.func_230982_a_(mouseX, mouseY);
        } else if (this.downButton.func_231047_b_(mouseX, mouseY)) {
            this.downButton.func_230982_a_(mouseX, mouseY);
        } else {
            super.func_230982_a_(mouseX, mouseY);
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        int xAxis = mouseX - this.guiObj.getLeft();
        int yAxis = mouseY - this.guiObj.getTop();
        if (this.upButton.isMouseOverCheckWindows(mouseX, mouseY)) {
            this.upButton.func_230443_a_(matrix, xAxis, yAxis);
        } else if (this.downButton.isMouseOverCheckWindows(mouseX, mouseY)) {
            this.downButton.func_230443_a_(matrix, xAxis, yAxis);
        } else {
            super.renderForeground(matrix, mouseX, mouseY);
        }
        IFilter filter = (IFilter)((HashList)this.filters.get()).getOrNull(this.filterIndex.getAsInt() + this.index);
        if (filter != this.prevFilter) {
            this.slotDisplay.updateStackList();
            this.prevFilter = filter;
        }
        int x = this.field_230690_l_ - this.guiObj.getLeft();
        int y = this.field_230691_m_ - this.guiObj.getTop();
        if (filter instanceof IItemStackFilter) {
            this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.ITEM_FILTER.translate(new Object[0]), x + 22, y + 2, this.titleTextColor(), 60.0f);
        } else if (filter instanceof ITagFilter) {
            this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.TAG_FILTER.translate(new Object[0]), x + 22, y + 2, this.titleTextColor(), 60.0f);
        } else if (filter instanceof IMaterialFilter) {
            this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.MATERIAL_FILTER.translate(new Object[0]), x + 22, y + 2, this.titleTextColor(), 60.0f);
        } else if (filter instanceof IModIDFilter) {
            this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.MODID_FILTER.translate(new Object[0]), x + 22, y + 2, this.titleTextColor(), 60.0f);
        }
        if (filter instanceof SorterFilter) {
            SorterFilter sorterFilter = (SorterFilter)filter;
            this.drawString(matrix, (ITextComponent)(sorterFilter.color == null ? MekanismLang.NONE.translate(new Object[0]) : sorterFilter.color.getColoredName()), x + 22, y + 11, this.titleTextColor());
        }
    }

    @Override
    protected void setVisibility(boolean visible) {
        this.field_230694_p_ = visible;
        if (visible) {
            this.updateButtonVisibility();
        } else {
            this.upButton.field_230694_p_ = false;
            this.downButton.field_230694_p_ = false;
        }
    }

    private void updateButtonVisibility() {
        int index = this.filterIndex.getAsInt() + this.index;
        HashList filterList = (HashList)this.filters.get();
        IFilter filter = (IFilter)filterList.getOrNull(index);
        this.upButton.field_230694_p_ = filter != null && index > 0;
        this.downButton.field_230694_p_ = filter != null && index < filterList.size() - 1;
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        if (this.field_230694_p_) {
            this.updateButtonVisibility();
            this.upButton.onDrawBackground(matrix, mouseX, mouseY, partialTicks);
            this.downButton.onDrawBackground(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void colorButton() {
        IFilter filter = (IFilter)((HashList)this.filters.get()).getOrNull(this.filterIndex.getAsInt() + this.index);
        if (filter instanceof IItemStackFilter) {
            MekanismRenderer.color(EnumColor.INDIGO, 1.0f, 2.5f);
        } else if (filter instanceof ITagFilter) {
            MekanismRenderer.color(EnumColor.BRIGHT_GREEN, 1.0f, 2.5f);
        } else if (filter instanceof IMaterialFilter) {
            MekanismRenderer.color(EnumColor.PURPLE, 1.0f, 4.0f);
        } else if (filter instanceof IModIDFilter) {
            MekanismRenderer.color(EnumColor.PINK, 1.0f, 2.5f);
        }
    }
}

